/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFinderPublisher
extends Publisher
implements Serializable {
    public final String fileSet;
    public final String regexp;
    public final boolean succeedIfFound;
    public final boolean unstableIfFound;
    public final boolean alsoCheckConsoleOutput;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public TextFinderPublisher(String fileSet, String regexp, boolean succeedIfFound, boolean unstableIfFound, boolean alsoCheckConsoleOutput) {
        this.fileSet = Util.fixEmpty((String)fileSet.trim());
        this.regexp = regexp;
        this.succeedIfFound = succeedIfFound;
        this.unstableIfFound = unstableIfFound;
        this.alsoCheckConsoleOutput = alsoCheckConsoleOutput;
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.findText(build, listener.getLogger());
        return true;
    }

    private void findText(AbstractBuild build, PrintStream logger) throws IOException, InterruptedException {
        try {
            boolean foundText = false;
            if (this.alsoCheckConsoleOutput) {
                logger.println("Checking console output");
                foundText |= this.checkFile(build.getLogFile(), this.compilePattern(logger), logger, true);
            } else {
                logger.println("Checking " + this.regexp);
            }
            final RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
            if (this.fileSet != null) {
                foundText |= ((Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                        PrintStream logger = new PrintStream((OutputStream)ros);
                        FileSet fs = new FileSet();
                        Project p = new Project();
                        fs.setProject(p);
                        fs.setDir(ws);
                        fs.setIncludes(TextFinderPublisher.this.fileSet);
                        DirectoryScanner ds = fs.getDirectoryScanner(p);
                        String[] files = ds.getIncludedFiles();
                        if (files.length == 0) {
                            logger.println("Hudson Text Finder: File set '" + TextFinderPublisher.this.fileSet + "' is empty");
                            throw new AbortException();
                        }
                        Pattern pattern = TextFinderPublisher.this.compilePattern(logger);
                        boolean foundText = false;
                        for (String file : files) {
                            File f = new File(ws, file);
                            if (!f.exists()) {
                                logger.println("Hudson Text Finder: Unable to find file '" + f + "'");
                                continue;
                            }
                            if (!f.canRead()) {
                                logger.println("Hudson Text Finder: Unable to read from file '" + f + "'");
                                continue;
                            }
                            foundText |= TextFinderPublisher.this.checkFile(f, pattern, logger, false);
                        }
                        return foundText;
                    }
                })).booleanValue();
            }
            if (foundText != this.succeedIfFound) {
                build.setResult(this.unstableIfFound ? Result.UNSTABLE : Result.FAILURE);
            }
        }
        catch (AbortException e) {
            build.setResult(Result.UNSTABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFile(File f, Pattern pattern, PrintStream logger, boolean abortAfterFirstHit) {
        boolean bl;
        boolean logFilename = true;
        boolean foundText = false;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (logFilename) {
                    logger.println(f + ":");
                    logFilename = false;
                }
                logger.println(line);
                foundText = true;
                if (!abortAfterFirstHit) continue;
                bl = true;
            }
        }
        catch (IOException e) {
            try {
                logger.println("Hudson Text Finder: Error reading file '" + f + "' -- ignoring");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            return foundText;
        }
        IOUtils.closeQuietly((Reader)reader);
        return foundText;
        IOUtils.closeQuietly((Reader)reader);
        return bl;
    }

    private Pattern compilePattern(PrintStream logger) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regexp);
        }
        catch (PatternSyntaxException e) {
            logger.println("Hudson Text Finder: Unable to compileregular expression '" + this.regexp + "'");
            throw new AbortException();
        }
        return pattern;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Hudson Text Finder";
        }

        public String getHelpFile() {
            return "/plugin/text-finder/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckRegexp(@QueryParameter String value) throws IOException, ServletException {
            if ((value = Util.fixEmpty((String)value)) == null) {
                return FormValidation.ok();
            }
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }

    private static final class AbortException
    extends RuntimeException {
        private AbortException() {
        }
    }
}

