/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.ChangeSetReader;
import hudson.plugins.tfs.ChangeSetWriter;
import hudson.plugins.tfs.PluginImpl;
import hudson.plugins.tfs.TfTool;
import hudson.plugins.tfs.actions.CheckoutAction;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.Server;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import hudson.util.Scrambler;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamFoundationServerScm
extends SCM {
    private final String serverUrl;
    private final String projectPath;
    private final String localPath;
    private final String workspaceName;
    private final String userPassword;
    private final String userName;
    private final boolean useUpdate;
    private transient String normalizedWorkspaceName;

    @DataBoundConstructor
    public TeamFoundationServerScm(String serverUrl, String projectPath, String localPath, boolean useUpdate, String workspaceName, String userName, String userPassword) {
        this.serverUrl = serverUrl;
        this.projectPath = projectPath;
        this.useUpdate = useUpdate;
        this.localPath = Util.fixEmptyAndTrim((String)localPath) == null ? "." : localPath;
        this.workspaceName = Util.fixEmptyAndTrim((String)workspaceName) == null ? "Hudson-${JOB_NAME}" : workspaceName;
        this.userName = userName;
        this.userPassword = Scrambler.scramble((String)userPassword);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getUserPassword() {
        return Scrambler.descramble((String)this.userPassword);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNormalizedWorkspaceName(AbstractProject<?, ?> project) {
        if (this.normalizedWorkspaceName == null) {
            this.normalizedWorkspaceName = this.workspaceName;
            Matcher matcher = Pattern.compile("\\$\\{JOB_NAME\\}", 2).matcher(this.normalizedWorkspaceName);
            if (matcher.find()) {
                this.normalizedWorkspaceName = matcher.replaceAll(project.getName());
            }
            if ((matcher = Pattern.compile("\\$\\{USER_NAME\\}", 2).matcher(this.normalizedWorkspaceName)).find()) {
                this.normalizedWorkspaceName = matcher.replaceAll(System.getProperty("user.name"));
            }
        }
        return this.normalizedWorkspaceName;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspaceFilePath, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, (TaskListener)listener, workspaceFilePath));
        CheckoutAction action = new CheckoutAction(this.getNormalizedWorkspaceName(build.getProject()), this.projectPath, this.localPath, this.useUpdate);
        try {
            List<ChangeSet> list = action.checkout(server, build.getPreviousBuild() != null ? build.getPreviousBuild().getTimestamp() : null);
            ChangeSetWriter writer = new ChangeSetWriter();
            writer.write(list, changelogFile);
        }
        catch (ParseException pe) {
            listener.fatalError(pe.getMessage());
            throw new AbortException();
        }
        return true;
    }

    public boolean pollChanges(AbstractProject hudsonProject, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = hudsonProject.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, listener, workspace));
        try {
            return server.getProject(this.projectPath).getDetailedHistory(lastBuild.getTimestamp(), Calendar.getInstance()).size() > 0;
        }
        catch (ParseException pe) {
            listener.fatalError(pe.getMessage());
            throw new AbortException();
        }
    }

    protected Server createServer(TfTool tool) {
        return new Server(tool, this.getServerUrl(), this.getUserName(), this.getUserPassword());
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean supportsPolling() {
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeSetReader();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return workspace.child(this.localPath);
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.TFS_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<TeamFoundationServerScm> {
        public static final String USER_AT_DOMAIN_REGEX = "\\w+@\\w+";
        public static final String DOMAIN_SLASH_USER_REGEX = "\\w+\\\\\\w+";
        public static final String PROJECT_PATH_REGEX = "^\\$\\/.*";
        private String tfExecutable;

        protected DescriptorImpl() {
            super(TeamFoundationServerScm.class, null);
            this.load();
        }

        public String getTfExecutable() {
            if (this.tfExecutable == null) {
                return "tf";
            }
            return this.tfExecutable;
        }

        public void doExecutableCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp).process();
        }

        private void doRegexCheck(final String[] regexArray, final String noMatchText, final String nullText, StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (value == null) {
                        if (nullText == null) {
                            this.ok();
                        } else {
                            this.error(nullText);
                        }
                        return;
                    }
                    for (String regex : regexArray) {
                        if (!value.matches(regex)) continue;
                        this.ok();
                        return;
                    }
                    this.error(noMatchText);
                }
            }.process();
        }

        public void doUsernameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            this.doRegexCheck(new String[]{DOMAIN_SLASH_USER_REGEX, USER_AT_DOMAIN_REGEX}, "Login name must contain the name of the domain and user", null, req, rsp);
        }

        public void doProjectPathCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            this.doRegexCheck(new String[]{PROJECT_PATH_REGEX}, "Project path must begin with '$/'.", "Project path is mandatory.", req, rsp);
        }

        public void doFieldCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            try {
                int hudsonMinorVersion = Integer.parseInt(Hudson.VERSION.substring(Hudson.VERSION.indexOf(46) + 1));
                if (hudsonMinorVersion >= 216) {
                    Hudson.getInstance().doFieldCheck(req, rsp);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.tfExecutable = Util.fixEmpty((String)req.getParameter("tfs.tfExecutable").trim());
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "Team Foundation Server";
        }
    }
}

