/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class ChangeSet
extends ChangeLogSet.Entry {
    private String version;
    private String user;
    private String domain;
    private Date date;
    private String comment;
    private List<Item> items;
    private static final ThreadLocal<SimpleDateFormat> TFS_DATETIME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            return dateFormat;
        }
    };

    public ChangeSet() {
        this("", null, "", "");
    }

    public ChangeSet(String version, Date date, String user, String comment) {
        this.version = version;
        this.date = date;
        this.comment = comment;
        this.items = new ArrayList<Item>();
        this.setUser(user);
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.items.size());
        for (Item item : this.items) {
            paths.add(item.getPath());
        }
        return paths;
    }

    public User getAuthor() {
        return User.get((String)this.user);
    }

    public String getMsg() {
        return this.comment;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Exported
    public String getDomain() {
        return this.domain;
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        String[] split = user.split("\\\\");
        if (split.length == 2) {
            this.domain = split[0];
            this.user = split[1];
        } else {
            this.user = user;
            this.domain = null;
        }
    }

    @Exported
    public Date getDate() {
        return this.date;
    }

    public void setDateStr(String dateStr) throws ParseException {
        this.date = TFS_DATETIME_FORMATTER.get().parse(dateStr);
    }

    @Exported
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Exported
    public List<Item> getItems() {
        return this.items;
    }

    public void add(Item item) {
        this.items.add(item);
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    @ExportedBean(defaultVisibility=999)
    public static class Item {
        private String path;
        private String action;

        public Item() {
            this("", "");
        }

        public Item(String path, String action) {
            this.path = path;
            this.action = action;
        }

        @Exported
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Exported
        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        @Exported
        public EditType getEditType() {
            if (this.action.equalsIgnoreCase("delete")) {
                return EditType.DELETE;
            }
            if (this.action.equalsIgnoreCase("add")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }
    }
}

