/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.util.ArgumentListBuilder;
import java.util.Collection;
import java.util.HashSet;

public class MaskedArgumentListBuilder
extends ArgumentListBuilder {
    private static final long serialVersionUID = 1L;
    private Collection<Integer> maskedArgumentIndex;

    public ArgumentListBuilder prepend(String ... args) {
        if (this.maskedArgumentIndex != null) {
            HashSet<Integer> newMaskedArgumentIndex = new HashSet<Integer>();
            for (Integer argIndex : this.maskedArgumentIndex) {
                newMaskedArgumentIndex.add(argIndex + args.length);
            }
            this.maskedArgumentIndex = newMaskedArgumentIndex;
        }
        return super.prepend(args);
    }

    public boolean hasMaskedArguments() {
        return this.maskedArgumentIndex != null;
    }

    public boolean[] toMaskArray() {
        String[] commands = this.toCommandArray();
        boolean[] mask = new boolean[commands.length];
        if (this.maskedArgumentIndex != null) {
            for (Integer argIndex : this.maskedArgumentIndex) {
                mask[argIndex.intValue()] = true;
            }
        }
        return mask;
    }

    public void addMasked(String string) {
        if (this.maskedArgumentIndex == null) {
            this.maskedArgumentIndex = new HashSet<Integer>();
        }
        this.maskedArgumentIndex.add(this.toCommandArray().length);
        this.add(string);
    }
}

