/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.model.User;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.DateUtil;
import hudson.scm.ChangeLogSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class ChangeSet
extends ChangeLogSet.Entry {
    private String version;
    private String user;
    private String domain;
    private Date date;
    private String comment;
    private List<Item> items;

    public ChangeSet() {
        this("", null, "", "");
    }

    public ChangeSet(String version, Date date, String user, String comment) {
        this.version = version;
        this.date = date;
        this.comment = comment;
        this.items = new ArrayList();
        this.setUser(user);
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.items.size());
        for (Item item : this.items) {
            paths.add(item.getPath());
        }
        return paths;
    }

    public User getAuthor() {
        return User.get((String)this.user);
    }

    public String getMsg() {
        return this.comment;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Exported
    public String getDomain() {
        return this.domain;
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        String[] split = user.split("\\\\");
        if (split.length == 2) {
            this.domain = split[0];
            this.user = split[1];
        } else {
            this.user = user;
            this.domain = null;
        }
    }

    @Exported
    public Date getDate() {
        return this.date;
    }

    public void setDateStr(String dateStr) throws ParseException {
        this.date = ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).parse(dateStr);
    }

    @Exported
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Exported
    public List<Item> getItems() {
        return this.items;
    }

    public void add(Item item) {
        this.items.add(item);
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }
}

