/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.Workspace;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWorkspacesCommand
extends AbstractCommand
implements ParseableCommand<List<Workspace>> {
    static final Pattern BRIEF_WORKSPACE_LIST_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*(.*)");
    private final WorkspaceFactory factory;

    public ListWorkspacesCommand(WorkspaceFactory factory, ServerConfigurationProvider provider) {
        super(provider);
        this.factory = factory;
    }

    @Override
    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("workspaces");
        arguments.add("/format:brief");
        this.addServerArgument(arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    @Override
    public List<Workspace> parse(Reader consoleReader) throws IOException {
        ArrayList<Workspace> list = new ArrayList<Workspace>();
        BufferedReader reader = new BufferedReader(consoleReader);
        String line = reader.readLine();
        while (line != null && !line.startsWith("---------")) {
            line = reader.readLine();
        }
        line = reader.readLine();
        while (line != null) {
            Matcher matcher = BRIEF_WORKSPACE_LIST_PATTERN.matcher(line);
            if (matcher.find()) {
                Workspace workspace = this.factory.createWorkspace(matcher.group(1), matcher.group(3), matcher.group(2), matcher.group(4));
                list.add(workspace);
            }
            line = reader.readLine();
        }
        return list;
    }

    public static interface WorkspaceFactory {
        public Workspace createWorkspace(String var1, String var2, String var3, String var4);
    }
}

