/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.plugins.tfs.commands.DeleteWorkspaceCommand;
import hudson.plugins.tfs.commands.ListWorkspacesCommand;
import hudson.plugins.tfs.commands.NewWorkspaceCommand;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.Workspace;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspaces
implements ListWorkspacesCommand.WorkspaceFactory {
    private Map<String, Workspace> workspaces = new HashMap<String, Workspace>();
    private Server server;
    private boolean mapIsPopulatedFromServer;

    public Workspaces(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Workspace> getListFromServer() throws IOException, InterruptedException {
        Object object;
        ListWorkspacesCommand command = new ListWorkspacesCommand(this, this.server);
        Reader reader = null;
        try {
            reader = this.server.execute(command.getArguments());
            object = command.parse(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return object;
    }

    private void populateMapFromServer() throws IOException, InterruptedException {
        if (!this.mapIsPopulatedFromServer) {
            for (Workspace workspace : this.getListFromServer()) {
                this.workspaces.put(workspace.getName(), workspace);
            }
            this.mapIsPopulatedFromServer = true;
        }
    }

    public Workspace getWorkspace(String workspaceName) throws IOException, InterruptedException {
        if (!this.workspaces.containsKey(workspaceName)) {
            this.populateMapFromServer();
        }
        return this.workspaces.get(workspaceName);
    }

    public boolean exists(Workspace workspace) throws IOException, InterruptedException {
        if (!this.workspaces.containsKey(workspace.getName())) {
            this.populateMapFromServer();
        }
        return this.workspaces.containsKey(workspace.getName());
    }

    public Workspace newWorkspace(String name) throws IOException, InterruptedException {
        NewWorkspaceCommand command = new NewWorkspaceCommand(this.server, name);
        this.server.execute(command.getArguments()).close();
        Workspace workspace = new Workspace(this.server, name);
        this.workspaces.put(name, workspace);
        return workspace;
    }

    public void deleteWorkspace(Workspace workspace) throws IOException, InterruptedException {
        DeleteWorkspaceCommand command = new DeleteWorkspaceCommand(this.server, workspace.getName());
        this.workspaces.remove(workspace.getName());
        this.server.execute(command.getArguments()).close();
    }

    @Override
    public Workspace createWorkspace(String name, String computer, String owner, String comment) {
        return new Workspace(this.server, name, computer, owner, comment);
    }
}

