/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import hudson.util.ArgumentListBuilder;

public class MapWorkfolderCommand
extends AbstractCommand {
    private final String projectPath;
    private final String workFolder;
    private final String workspaceName;

    public MapWorkfolderCommand(ServerConfigurationProvider provider, String projectPath, String workFolder) {
        this(provider, projectPath, workFolder, null);
    }

    public MapWorkfolderCommand(ServerConfigurationProvider provider, String projectPath, String workFolder, String workspaceName) {
        super(provider);
        this.projectPath = projectPath;
        this.workFolder = workFolder;
        this.workspaceName = workspaceName;
    }

    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("workfold");
        arguments.add("-map");
        arguments.add(this.projectPath);
        arguments.add(this.workFolder);
        if (this.workspaceName != null) {
            arguments.add(String.format("-workspace:%s", this.workspaceName));
        }
        this.addServerArgument((ArgumentListBuilder)arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }
}

