/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.tfs.util.BuildVariableResolver;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildVariableResolver
implements VariableResolver<String> {
    private Map<String, LazyResolver> lazyResolvers = new HashMap();
    private List<VariableResolver<String>> otherResolvers = new ArrayList();
    private final Computer computer;
    private static final Logger LOGGER = Logger.getLogger(BuildVariableResolver.class.getName());

    public BuildVariableResolver(Job<?, ?> job) {
        this.computer = null;
        this.lazyResolvers.put("JOB_NAME", new /* Unavailable Anonymous Inner Class!! */);
    }

    public BuildVariableResolver(AbstractProject<?, ?> project, Computer computer) {
        this.computer = computer;
        this.lazyResolvers.put("JOB_NAME", new /* Unavailable Anonymous Inner Class!! */);
        this.lazyResolvers.put("NODE_NAME", new /* Unavailable Anonymous Inner Class!! */);
        this.lazyResolvers.put("USER_NAME", new /* Unavailable Anonymous Inner Class!! */);
    }

    public BuildVariableResolver(AbstractBuild<?, ?> build, Computer computer) throws IOException, InterruptedException {
        this(build.getProject(), computer);
        EnvVars envVars = build.getEnvironment(TaskListener.NULL);
        if (envVars != null) {
            this.otherResolvers.add(new VariableResolver.ByMap((Map)envVars));
        }
    }

    public String resolve(String variable) {
        try {
            if (this.lazyResolvers.containsKey(variable)) {
                return ((LazyResolver)this.lazyResolvers.get(variable)).getValue();
            }
            if (this.computer != null) {
                this.otherResolvers.add(new VariableResolver.ByMap((Map)this.computer.getEnvironment()));
            }
            return (String)new VariableResolver.Union((Collection)this.otherResolvers).resolve(variable);
        }
        catch (Exception e) {
            LOGGER.warning("Variable name '" + variable + "' look up failed because of " + e);
            return null;
        }
    }

    static /* synthetic */ Computer access$100(BuildVariableResolver x0) {
        return x0.computer;
    }
}

