/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    public static final ThreadLocal<SimpleDateFormat> TFS_DATETIME_FORMATTER = new /* Unavailable Anonymous Inner Class!! */;

    private DateUtil() {
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DateUtil.parseDate((String)dateString, (Locale)Locale.getDefault(), (TimeZone)TimeZone.getDefault());
    }

    public static Date parseDate(String dateString, Locale locale, TimeZone timezone) throws ParseException {
        Date date = null;
        dateString = dateString.replaceAll("(p|P)\\.(m|M)\\.", "PM").replaceAll("(a|A)\\.(m|M)\\.", "AM");
        try {
            date = new Date(Date.parse(dateString));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (date == null) {
            DateFormat[] formats = DateUtil.createDateFormatsForLocaleAndTimeZone((Locale)locale, (TimeZone)timezone);
            return DateUtil.parseWithFormats((String)dateString, (DateFormat[])formats);
        }
        return date;
    }

    static Date parseWithFormats(String input, DateFormat[] formats) throws ParseException {
        ParseException parseException = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(input);
            }
            catch (ParseException ex) {
                parseException = ex;
                continue;
            }
        }
        if (parseException == null) {
            throw new IllegalStateException("No dateformats found that can be used for parsing '" + input + "'");
        }
        throw parseException;
    }

    static DateFormat[] createDateFormatsForLocaleAndTimeZone(Locale locale, TimeZone timeZone) {
        ArrayList formats = new ArrayList();
        DateUtil.addDateTimeFormatsToList((Locale)locale, (TimeZone)timeZone, formats);
        DateUtil.addDateFormatsToList((Locale)locale, (TimeZone)timeZone, formats);
        return formats.toArray(new DateFormat[formats.size()]);
    }

    static void addDateFormatsToList(Locale locale, TimeZone timeZone, List<DateFormat> formats) {
        for (int dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
            df.setTimeZone(timeZone);
            formats.add(df);
        }
    }

    static void addDateTimeFormatsToList(Locale locale, TimeZone timeZone, List<DateFormat> formats) {
        for (int dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            for (int timeStyle = 0; timeStyle <= 3; ++timeStyle) {
                DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                if (timeZone != null) {
                    df.setTimeZone(timeZone);
                }
                formats.add(df);
            }
        }
    }
}

