/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.DetailedHistoryCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.DateParser;
import hudson.plugins.tfs.util.DateUtil;
import hudson.plugins.tfs.util.KeyValueTextReader;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedHistoryCommand
extends AbstractCommand
implements ParseableCommand<List<ChangeSet>> {
    public static final String IGNORE_DATE_CHECK_ON_CHANGE_SET = "tfs.history.skipdatecheck";
    private static final String CHANGESET_SEPERATOR = "------------";
    private static final Pattern PATTERN_CHANGESET = Pattern.compile("^[^:]*:[ \t]([0-9]*)\n[^:]*:[ \t](.*)\n[^:]*:[ \t](.*)\n[^:]*:(?s)(.*)\n\n[^\n :]*:(?=\n  )(.*)\n\n");
    private static final Pattern PATTERN_ITEM = Pattern.compile("\\s*([^$]+) (\\$/.*)");
    private final String projectPath;
    private final Calendar fromTimestamp;
    private final Calendar toTimestamp;
    private final DateParser dateParser;
    private final boolean skipDateCheckInParsing;

    public DetailedHistoryCommand(ServerConfigurationProvider configurationProvider, String projectPath, Calendar fromTimestamp, Calendar toTimestamp, DateParser dateParser) {
        super(configurationProvider);
        this.projectPath = projectPath;
        this.fromTimestamp = fromTimestamp;
        this.dateParser = dateParser;
        this.skipDateCheckInParsing = Boolean.valueOf(System.getProperty(IGNORE_DATE_CHECK_ON_CHANGE_SET));
        this.toTimestamp = (Calendar)toTimestamp.clone();
        this.toTimestamp.add(13, 1);
    }

    public DetailedHistoryCommand(ServerConfigurationProvider provider, String projectPath, Calendar fromTimestamp, Calendar toTimestamp) {
        this(provider, projectPath, fromTimestamp, toTimestamp, new DateParser());
    }

    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("history");
        arguments.add(this.projectPath);
        arguments.add("-noprompt");
        arguments.add(String.format("-version:D%s~D%s", ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).format(this.fromTimestamp.getTime()), ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).format(this.toTimestamp.getTime())));
        arguments.add("-recursive");
        arguments.add("-format:detailed");
        this.addServerArgument((ArgumentListBuilder)arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    public List<ChangeSet> parse(Reader reader) throws IOException, ParseException {
        Date lastBuildDate = this.fromTimestamp.getTime();
        ArrayList<ChangeSet> list = new ArrayList<ChangeSet>();
        ChangeSetStringReader iterator = new ChangeSetStringReader(new BufferedReader(reader));
        String changeSetString = iterator.readChangeSet();
        while (changeSetString != null) {
            ChangeSet changeSet = this.parseChangeSetString(changeSetString);
            if (changeSet == null) {
                changeSet = this.parseChangeSetStringWithRegex(changeSetString);
            }
            if (changeSet == null) {
                throw new ParseException("Parse error. Unable to find an item within a changeset.  Please report this as a bug.  Changesetdata = \"\n" + changeSetString + "\n\".", 0);
            }
            if (this.skipDateCheckInParsing || changeSet.getDate().compareTo(lastBuildDate) > 0) {
                list.add(changeSet);
            }
            changeSetString = iterator.readChangeSet();
        }
        Collections.reverse(list);
        return list;
    }

    private ChangeSet parseChangeSetString(String changeSetString) throws ParseException, IOException {
        KeyValueTextReader reader = new KeyValueTextReader();
        Map map = reader.parse(changeSetString);
        if (map.containsKey("User") && map.containsKey("Changeset") && map.containsKey("Date") && map.containsKey("Items")) {
            ChangeSet changeSet = this.createChangeSet((String)map.get("Items"), (String)map.get("Changeset"), (String)map.get("User"), (String)map.get("Date"), (String)map.get("Comment"));
            if (changeSet != null) {
                changeSet.setCheckedInBy((String)map.get("Checked in by"));
            }
            return changeSet;
        }
        return null;
    }

    private ChangeSet parseChangeSetStringWithRegex(String changeSetString) throws ParseException {
        Matcher m = PATTERN_CHANGESET.matcher(changeSetString);
        if (m.find()) {
            String revision = m.group(1);
            String userName = m.group(2).trim();
            String comment = m.group(4).replaceAll("\n  ", "\n");
            if (comment.length() > 0) {
                comment = comment.trim();
            }
            return this.createChangeSet(m.group(5), revision, userName, m.group(3), comment);
        }
        return null;
    }

    private ChangeSet createChangeSet(String items, String revision, String userName, String modifiedTime, String comment) throws ParseException {
        Matcher itemMatcher = PATTERN_ITEM.matcher(items);
        ChangeSet changeset = null;
        while (itemMatcher.find()) {
            if (changeset == null) {
                changeset = new ChangeSet(revision, this.dateParser.parseDate(modifiedTime), userName, comment);
            }
            String path = itemMatcher.group(2);
            String action = itemMatcher.group(1).trim();
            if (!path.startsWith("$/")) {
                throw new ParseException("Parse error. Mistakenly identified \"" + path + "\" as an item, but it does not appear to " + "be a valid TFS path.  Please report this as a bug.  Changeset" + "data = \"\n" + items + "\n\".", itemMatcher.start());
            }
            changeset.getItems().add(new ChangeSet.Item(path, action));
        }
        return changeset;
    }
}

