/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.plugins.tfs.commands.BriefHistoryCommand;
import hudson.plugins.tfs.commands.DetailedHistoryCommand;
import hudson.plugins.tfs.commands.GetFilesToWorkFolderCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.Server;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private final String projectPath;
    private final Server server;

    public Project(Server server, String projectPath) {
        this.server = server;
        this.projectPath = projectPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeSet> getDetailedHistory(Calendar fromTimestamp, Calendar toTimestamp) throws IOException, InterruptedException, ParseException {
        List list;
        DetailedHistoryCommand command = new DetailedHistoryCommand((ServerConfigurationProvider)this.server, this.projectPath, fromTimestamp, toTimestamp);
        Reader reader = null;
        try {
            reader = this.server.execute(command.getArguments());
            list = command.parse(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeSet> getBriefHistory(Calendar fromTimestamp, Calendar toTimestamp) throws IOException, InterruptedException, ParseException {
        List list;
        BriefHistoryCommand command = new BriefHistoryCommand((ServerConfigurationProvider)this.server, this.projectPath, fromTimestamp, toTimestamp);
        Reader reader = null;
        try {
            reader = this.server.execute(command.getArguments());
            list = command.parse(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public void getFiles(String localPath) throws IOException, InterruptedException {
        GetFilesToWorkFolderCommand command = new GetFilesToWorkFolderCommand((ServerConfigurationProvider)this.server, localPath);
        this.server.execute(command.getArguments()).close();
    }

    public void getFiles(String localPath, String versionSpec) throws IOException, InterruptedException {
        GetFilesToWorkFolderCommand command = new GetFilesToWorkFolderCommand((ServerConfigurationProvider)this.server, localPath, versionSpec);
        this.server.execute(command.getArguments()).close();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 27).append((Object)this.projectPath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.projectPath, (Object)other.projectPath);
        return builder.isEquals();
    }
}

