/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.plugins.tfs.commands.GetWorkspaceMappingsCommand;
import hudson.plugins.tfs.commands.MapWorkfolderCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.commands.UnmapWorkfolderCommand;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.WorkspaceMapping;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace {
    private final Server server;
    private final String name;
    private final String computer;
    private final String owner;
    private final String comment;

    public Workspace(Server server, String name, String computer, String owner, String comment) {
        this.server = server;
        this.name = name;
        this.computer = computer;
        this.owner = owner;
        this.comment = comment;
    }

    public Workspace(Server server, String name) {
        this(server, name, "", "", "");
    }

    public void mapWorkfolder(Project project, String workFolder) throws IOException, InterruptedException {
        MapWorkfolderCommand command = new MapWorkfolderCommand((ServerConfigurationProvider)this.server, project.getProjectPath(), workFolder, this.name);
        this.server.execute(command.getArguments()).close();
    }

    public void unmapWorkfolder(String workFolder) throws IOException, InterruptedException {
        UnmapWorkfolderCommand command = new UnmapWorkfolderCommand((ServerConfigurationProvider)this.server, workFolder, this.name);
        this.server.execute(command.getArguments()).close();
    }

    public List<WorkspaceMapping> getMappings() throws IOException, InterruptedException, ParseException {
        GetWorkspaceMappingsCommand command = new GetWorkspaceMappingsCommand((ServerConfigurationProvider)this.server, this.name);
        Reader reader = this.server.execute(command.getArguments());
        List mappings = command.parse(reader);
        reader.close();
        return mappings;
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.server.getWorkspaces().exists(this);
    }

    public String getName() {
        return this.name;
    }

    public String getComputer() {
        return this.computer;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 27).append((Object)this.name).append((Object)this.owner).append((Object)this.computer).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Workspace other = (Workspace)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.name, (Object)other.name);
        builder.append((Object)this.owner, (Object)other.owner);
        builder.append((Object)this.computer, (Object)other.computer);
        return builder.isEquals();
    }
}

