/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.model.InvisibleAction;
import java.io.Serializable;

public class WorkspaceConfiguration
extends InvisibleAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String workspaceName;
    private final String workfolder;
    private final String projectPath;
    private final String serverUrl;
    private boolean workspaceExists;

    public WorkspaceConfiguration(String serverUrl, String workspaceName, String projectPath, String workfolder) {
        this.workspaceName = workspaceName;
        this.workfolder = workfolder;
        this.projectPath = projectPath;
        this.serverUrl = serverUrl;
        this.workspaceExists = true;
    }

    public WorkspaceConfiguration(WorkspaceConfiguration configuration) {
        this.workspaceName = configuration.workspaceName;
        this.workfolder = configuration.workfolder;
        this.projectPath = configuration.projectPath;
        this.serverUrl = configuration.serverUrl;
        this.workspaceExists = configuration.workspaceExists;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getWorkfolder() {
        return this.workfolder;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean workspaceExists() {
        return this.workspaceExists;
    }

    public void setWorkspaceWasRemoved() {
        this.workspaceExists = false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projectPath == null ? 0 : this.projectPath.hashCode());
        result = 31 * result + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        result = 31 * result + (this.workfolder == null ? 0 : this.workfolder.hashCode());
        result = 31 * result + (this.workspaceExists ? 1231 : 1237);
        result = 31 * result + (this.workspaceName == null ? 0 : this.workspaceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceConfiguration)) {
            return false;
        }
        WorkspaceConfiguration other = (WorkspaceConfiguration)obj;
        if (this.projectPath == null ? other.projectPath != null : !this.projectPath.equals(other.projectPath)) {
            return false;
        }
        if (this.serverUrl == null ? other.serverUrl != null : !this.serverUrl.equals(other.serverUrl)) {
            return false;
        }
        if (this.workfolder == null ? other.workfolder != null : !this.workfolder.equals(other.workfolder)) {
            return false;
        }
        if (this.workspaceExists != other.workspaceExists) {
            return false;
        }
        return !(this.workspaceName == null ? other.workspaceName != null : !this.workspaceName.equals(other.workspaceName));
    }

    public String toString() {
        return String.format("WorkspaceConfiguration [projectPath=%s, serverUrl=%s, workfolder=%s, workspaceExists=%s, workspaceName=%s]", this.projectPath, this.serverUrl, this.workfolder, this.workspaceExists, this.workspaceName);
    }
}

