/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.Util;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.DateUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<ChangeSet> changeSets, File changelogFile) throws IOException {
        FileWriter writer = new FileWriter(changelogFile);
        try {
            this.write(changeSets, writer);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void write(List<ChangeSet> changeSets, Writer output) {
        PrintWriter writer = new PrintWriter(output);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<changelog>");
        for (ChangeSet changeSet : changeSets) {
            writer.println(String.format("\t<changeset version=\"%s\">", changeSet.getVersion()));
            this.write(changeSet, writer);
            writer.println("\t</changeset>");
        }
        writer.println("</changelog>");
        writer.flush();
    }

    private void write(ChangeSet changeSet, PrintWriter writer) {
        writer.println(String.format("\t\t<date>%s</date>", DateUtil.TFS_DATETIME_FORMATTER.get().format(changeSet.getDate())));
        if (Util.fixEmpty((String)changeSet.getDomain()) == null) {
            writer.println(String.format("\t\t<user>%s</user>", this.escapeForXml(changeSet.getUser())));
        } else {
            writer.println(String.format("\t\t<user>%s\\%s</user>", this.escapeForXml(changeSet.getDomain()), this.escapeForXml(changeSet.getUser())));
        }
        if (Util.fixEmpty((String)changeSet.getCheckedInBy()) != null) {
            writer.println(String.format("\t\t<checked_in_by_user>%s</checked_in_by_user>", this.escapeForXml(changeSet.getCheckedInBy())));
        }
        writer.println(String.format("\t\t<comment>%s</comment>", this.escapeForXml(changeSet.getComment())));
        if (changeSet.getItems().size() > 0) {
            writer.println("\t\t<items>");
            for (ChangeSet.Item item : changeSet.getItems()) {
                writer.println(String.format("\t\t\t<item action=\"%s\">%s</item>", this.escapeForXml(item.getAction()), this.escapeForXml(item.getPath())));
            }
            writer.println("\t\t</items>");
        }
    }

    private String escapeForXml(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        int size = string.length();
        StringBuilder escapedString = new StringBuilder(size);
        block7: for (int index = 0; index < size; ++index) {
            char ch = string.charAt(index);
            switch (ch) {
                case '&': {
                    escapedString.append("&amp;");
                    continue block7;
                }
                case '<': {
                    escapedString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedString.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    escapedString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    escapedString.append("&quot;");
                    continue block7;
                }
                default: {
                    escapedString.append(ch);
                }
            }
        }
        return escapedString.toString();
    }
}

