/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.ChangeSetReader;
import hudson.plugins.tfs.ChangeSetWriter;
import hudson.plugins.tfs.TfTool;
import hudson.plugins.tfs.actions.CheckoutAction;
import hudson.plugins.tfs.actions.RemoveWorkspaceAction;
import hudson.plugins.tfs.browsers.TeamFoundationServerRepositoryBrowser;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.WorkspaceConfiguration;
import hudson.plugins.tfs.util.BuildVariableResolver;
import hudson.plugins.tfs.util.BuildWorkspaceConfigurationRetriever;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import hudson.util.Scrambler;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamFoundationServerScm
extends SCM {
    public static final String WORKSPACE_ENV_STR = "TFS_WORKSPACE";
    public static final String WORKFOLDER_ENV_STR = "TFS_WORKFOLDER";
    public static final String PROJECTPATH_ENV_STR = "TFS_PROJECTPATH";
    public static final String SERVERURL_ENV_STR = "TFS_SERVERURL";
    public static final String USERNAME_ENV_STR = "TFS_USERNAME";
    private final String serverUrl;
    private final String projectPath;
    private final String localPath;
    private final String workspaceName;
    private final String userPassword;
    private final String userName;
    private final boolean useUpdate;
    private TeamFoundationServerRepositoryBrowser repositoryBrowser;
    private transient String normalizedWorkspaceName;
    private static final Logger logger = Logger.getLogger(TeamFoundationServerScm.class.getName());

    @DataBoundConstructor
    public TeamFoundationServerScm(String serverUrl, String projectPath, String localPath, boolean useUpdate, String workspaceName, String userName, String userPassword) {
        this.serverUrl = serverUrl;
        this.projectPath = projectPath;
        this.useUpdate = useUpdate;
        this.localPath = Util.fixEmptyAndTrim((String)localPath) == null ? "." : localPath;
        this.workspaceName = Util.fixEmptyAndTrim((String)workspaceName) == null ? "Hudson-${JOB_NAME}-${NODE_NAME}" : workspaceName;
        this.userName = userName;
        this.userPassword = Scrambler.scramble((String)userPassword);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getUserPassword() {
        return Scrambler.descramble((String)this.userPassword);
    }

    public String getUserName() {
        return this.userName;
    }

    String getWorkspaceName(AbstractBuild<?, ?> build, Computer computer) {
        this.normalizedWorkspaceName = this.workspaceName;
        if (build != null) {
            this.normalizedWorkspaceName = this.substituteBuildParameter((Run<?, ?>)build, this.normalizedWorkspaceName);
            this.normalizedWorkspaceName = Util.replaceMacro((String)this.normalizedWorkspaceName, (VariableResolver)new BuildVariableResolver(build.getProject(), computer));
        }
        this.normalizedWorkspaceName = this.normalizedWorkspaceName.replaceAll("[\"/:<>\\|\\*\\?]+", "_");
        this.normalizedWorkspaceName = this.normalizedWorkspaceName.replaceAll("[\\.\\s]+$", "_");
        return this.normalizedWorkspaceName;
    }

    public String getServerUrl(Run<?, ?> run) {
        return this.substituteBuildParameter(run, this.serverUrl);
    }

    String getProjectPath(Run<?, ?> run) {
        return Util.replaceMacro((String)this.substituteBuildParameter(run, this.projectPath), (VariableResolver)new BuildVariableResolver(run.getParent()));
    }

    private String substituteBuildParameter(Run<?, ?> run, String text) {
        AbstractBuild build;
        if (run instanceof AbstractBuild && (build = (AbstractBuild)run).getAction(ParametersAction.class) != null) {
            return ((ParametersAction)build.getAction(ParametersAction.class)).substitute(build, text);
        }
        return text;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspaceFilePath, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        BuildWorkspaceConfigurationRetriever.BuildWorkspaceConfiguration nodeConfiguration;
        Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, (TaskListener)listener, workspaceFilePath), (Run<?, ?>)build);
        WorkspaceConfiguration workspaceConfiguration = new WorkspaceConfiguration(server.getUrl(), this.getWorkspaceName(build, Computer.currentComputer()), this.getProjectPath((Run<?, ?>)build), this.getLocalPath());
        if (build.getPreviousBuild() != null && (nodeConfiguration = new BuildWorkspaceConfigurationRetriever().getLatestForNode(build.getBuiltOn(), build.getPreviousBuild())) != null && nodeConfiguration.workspaceExists() && !workspaceConfiguration.equals(nodeConfiguration)) {
            listener.getLogger().println("Deleting workspace as the configuration has changed since a build was performed on this computer.");
            new RemoveWorkspaceAction(workspaceConfiguration.getWorkspaceName()).remove(server);
            nodeConfiguration.setWorkspaceWasRemoved();
            nodeConfiguration.save();
        }
        build.addAction((Action)workspaceConfiguration);
        CheckoutAction action = new CheckoutAction(workspaceConfiguration.getWorkspaceName(), workspaceConfiguration.getProjectPath(), workspaceConfiguration.getWorkfolder(), this.isUseUpdate());
        try {
            List<ChangeSet> list = action.checkout(server, workspaceFilePath, build.getPreviousBuild() != null ? build.getPreviousBuild().getTimestamp() : null, build.getTimestamp());
            ChangeSetWriter writer = new ChangeSetWriter();
            writer.write(list, changelogFile);
        }
        catch (ParseException pe) {
            listener.fatalError(pe.getMessage());
            throw new AbortException();
        }
        return true;
    }

    public boolean pollChanges(AbstractProject hudsonProject, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastRun = hudsonProject.getLastBuild();
        if (lastRun == null) {
            return true;
        }
        Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, listener, workspace), lastRun);
        try {
            return server.getProject(this.getProjectPath(lastRun)).getDetailedHistory(lastRun.getTimestamp(), Calendar.getInstance()).size() > 0;
        }
        catch (ParseException pe) {
            listener.fatalError(pe.getMessage());
            throw new AbortException();
        }
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        BuildWorkspaceConfigurationRetriever.BuildWorkspaceConfiguration configuration;
        Run lastRun = project.getLastBuild();
        if (lastRun == null || !(lastRun instanceof AbstractBuild)) {
            return true;
        }
        if (node == null) {
            while (lastRun != null) {
                AbstractBuild build = (AbstractBuild)lastRun;
                Node buildNode = build.getBuiltOn();
                if (node == null) {
                    node = buildNode;
                } else if (!buildNode.getNodeName().equals(node.getNodeName())) {
                    logger.warning("Could not wipe out workspace as there is no way of telling what Node the request is for. Please upgrade Hudson to a newer version.");
                    return false;
                }
                lastRun = lastRun.getPreviousBuild();
            }
            if (node == null) {
                return true;
            }
            lastRun = project.getLastBuild();
        }
        if ((configuration = new BuildWorkspaceConfigurationRetriever().getLatestForNode(node, lastRun)) != null && configuration.workspaceExists()) {
            LogTaskListener listener = new LogTaskListener(logger, Level.INFO);
            Launcher launcher = node.createLauncher((TaskListener)listener);
            Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, (TaskListener)listener, workspace), lastRun);
            if (new RemoveWorkspaceAction(configuration.getWorkspaceName()).remove(server)) {
                configuration.setWorkspaceWasRemoved();
                configuration.save();
            }
        }
        return true;
    }

    protected Server createServer(TfTool tool, Run<?, ?> run) {
        return new Server(tool, this.getServerUrl(run), this.getUserName(), this.getUserPassword());
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public boolean supportsPolling() {
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeSetReader();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return workspace.child(this.getLocalPath());
    }

    public TeamFoundationServerRepositoryBrowser getBrowser() {
        return this.repositoryBrowser;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        if (this.normalizedWorkspaceName != null) {
            env.put(WORKSPACE_ENV_STR, this.normalizedWorkspaceName);
        }
        if (env.containsKey("WORKSPACE")) {
            env.put(WORKFOLDER_ENV_STR, env.get("WORKSPACE") + File.separator + this.getLocalPath());
        }
        if (this.projectPath != null) {
            env.put(PROJECTPATH_ENV_STR, this.projectPath);
        }
        if (this.serverUrl != null) {
            env.put(SERVERURL_ENV_STR, this.serverUrl);
        }
        if (this.userName != null) {
            env.put(USERNAME_ENV_STR, this.userName);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<TeamFoundationServerScm> {
        public static final Pattern WORKSPACE_NAME_REGEX = Pattern.compile("[^\"/:<>\\|\\*\\?]+[^\\s\\.\"/:<>\\|\\*\\?]$", 2);
        public static final Pattern USER_AT_DOMAIN_REGEX = Pattern.compile("^([^\\/\\\\\"\\[\\]:|<>+=;,\\*@]+)@([a-z][a-z0-9.-]+)$", 2);
        public static final Pattern DOMAIN_SLASH_USER_REGEX = Pattern.compile("^([a-z][a-z0-9.-]+)\\\\([^\\/\\\\\"\\[\\]:|<>+=;,\\*@]+)$", 2);
        public static final Pattern PROJECT_PATH_REGEX = Pattern.compile("^\\$\\/.*", 2);
        private String tfExecutable;

        public DescriptorImpl() {
            super(TeamFoundationServerScm.class, TeamFoundationServerRepositoryBrowser.class);
            this.load();
        }

        public String getTfExecutable() {
            if (this.tfExecutable == null) {
                return "tf";
            }
            return this.tfExecutable;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            TeamFoundationServerScm scm = (TeamFoundationServerScm)super.newInstance(req, formData);
            scm.repositoryBrowser = (TeamFoundationServerRepositoryBrowser)RepositoryBrowsers.createInstance(TeamFoundationServerRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            return scm;
        }

        public FormValidation doExecutableCheck(@QueryParameter String value) {
            return FormValidation.validateExecutable((String)value);
        }

        private FormValidation doRegexCheck(Pattern[] regexArray, String noMatchText, String nullText, String value) {
            if ((value = Util.fixEmpty((String)value)) == null) {
                if (nullText == null) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)nullText);
            }
            for (Pattern regex : regexArray) {
                if (!regex.matcher(value).matches()) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)noMatchText);
        }

        public FormValidation doUsernameCheck(@QueryParameter String value) {
            return this.doRegexCheck(new Pattern[]{DOMAIN_SLASH_USER_REGEX, USER_AT_DOMAIN_REGEX}, "Login name must contain the name of the domain and user", null, value);
        }

        public FormValidation doProjectPathCheck(@QueryParameter String value) {
            return this.doRegexCheck(new Pattern[]{PROJECT_PATH_REGEX}, "Project path must begin with '$/'.", "Project path is mandatory.", value);
        }

        public FormValidation doWorkspaceNameCheck(@QueryParameter String value) {
            return this.doRegexCheck(new Pattern[]{WORKSPACE_NAME_REGEX}, "Workspace name cannot end with a space or period, and cannot contain any of the following characters: \"/:<>|*?", "Workspace name is mandatory", value);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.tfExecutable = Util.fixEmpty((String)req.getParameter("tfs.tfExecutable").trim());
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "Team Foundation Server";
        }
    }
}

