/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.actions;

import hudson.FilePath;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.Workspace;
import hudson.plugins.tfs.model.Workspaces;
import hudson.plugins.tfs.util.DateUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutAction {
    private final String workspaceName;
    private final String projectPath;
    private final String localFolder;
    private final boolean useUpdate;

    public CheckoutAction(String workspaceName, String projectPath, String localFolder, boolean useUpdate) {
        this.workspaceName = workspaceName;
        this.projectPath = projectPath;
        this.localFolder = localFolder;
        this.useUpdate = useUpdate;
    }

    public List<ChangeSet> checkout(Server server, FilePath workspacePath, Calendar lastBuildTimestamp, Calendar currentBuildTimestamp) throws IOException, InterruptedException, ParseException {
        Workspace workspace;
        Workspaces workspaces = server.getWorkspaces();
        Project project = server.getProject(this.projectPath);
        if (workspaces.exists(this.workspaceName) && !this.useUpdate) {
            workspace = workspaces.getWorkspace(this.workspaceName);
            workspaces.deleteWorkspace(workspace);
        }
        if (!workspaces.exists(this.workspaceName)) {
            FilePath localFolderPath = workspacePath.child(this.localFolder);
            if (!this.useUpdate && localFolderPath.exists()) {
                localFolderPath.deleteContents();
            }
            workspace = workspaces.newWorkspace(this.workspaceName);
            workspace.mapWorkfolder(project, this.localFolder);
        } else {
            workspace = workspaces.getWorkspace(this.workspaceName);
        }
        project.getFiles(this.localFolder, "D" + DateUtil.TFS_DATETIME_FORMATTER.get().format(currentBuildTimestamp.getTime()));
        if (lastBuildTimestamp != null) {
            return project.getDetailedHistory(lastBuildTimestamp, currentBuildTimestamp);
        }
        return new ArrayList<ChangeSet>();
    }
}

