/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildVariableResolver
implements VariableResolver<String> {
    private Map<String, LazyResolver> lazyResolvers = new HashMap<String, LazyResolver>();
    private List<VariableResolver<String>> otherResolvers = new ArrayList<VariableResolver<String>>();
    private final Computer computer;
    private static final Logger LOGGER = Logger.getLogger(BuildVariableResolver.class.getName());

    public BuildVariableResolver(final Job<?, ?> job) {
        this.computer = null;
        this.lazyResolvers.put("JOB_NAME", new LazyResolver(){

            public String getValue() {
                return job.getName();
            }
        });
    }

    public BuildVariableResolver(final AbstractProject<?, ?> project, Computer computer) {
        this.computer = computer;
        this.lazyResolvers.put("JOB_NAME", new LazyResolver(){

            public String getValue() {
                return project.getName();
            }
        });
        this.lazyResolvers.put("NODE_NAME", new LazyComputerResolver(){

            public String getValue(Computer computer) {
                return Util.fixEmpty((String)computer.getName()) == null ? "MASTER" : computer.getName();
            }
        });
        this.lazyResolvers.put("USER_NAME", new LazyComputerResolver(){

            public String getValue(Computer computer) throws IOException, InterruptedException {
                return (String)computer.getSystemProperties().get("user.name");
            }
        });
    }

    public BuildVariableResolver(AbstractBuild<?, ?> build, Computer computer) throws IOException, InterruptedException {
        this(build.getProject(), computer);
        EnvVars envVars = build.getEnvironment(TaskListener.NULL);
        if (envVars != null) {
            this.otherResolvers.add((VariableResolver<String>)new VariableResolver.ByMap((Map)envVars));
        }
    }

    public String resolve(String variable) {
        try {
            if (this.lazyResolvers.containsKey(variable)) {
                return this.lazyResolvers.get(variable).getValue();
            }
            if (this.computer != null) {
                this.otherResolvers.add((VariableResolver<String>)new VariableResolver.ByMap((Map)this.computer.getEnvironment()));
            }
            return (String)new VariableResolver.Union(this.otherResolvers).resolve(variable);
        }
        catch (Exception e) {
            LOGGER.warning("Variable name '" + variable + "' look up failed because of " + e);
            return null;
        }
    }

    private abstract class LazyComputerResolver
    implements LazyResolver {
        private LazyComputerResolver() {
        }

        protected abstract String getValue(Computer var1) throws IOException, InterruptedException;

        public String getValue() throws IOException, InterruptedException {
            return this.getValue(BuildVariableResolver.this.computer);
        }
    }

    private static interface LazyResolver {
        public String getValue() throws IOException, InterruptedException;
    }
}

