/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    public static final ThreadLocal<SimpleDateFormat> TFS_DATETIME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            return dateFormat;
        }
    };

    private DateUtil() {
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DateUtil.parseDate(dateString, Locale.getDefault(), TimeZone.getDefault());
    }

    public static Date parseDate(String dateString, Locale locale, TimeZone timezone) throws ParseException {
        Date date = null;
        dateString = dateString.replaceAll("(p|P)\\.(m|M)\\.", "PM").replaceAll("(a|A)\\.(m|M)\\.", "AM");
        try {
            date = new Date(Date.parse(dateString));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (date == null) {
            DateFormat[] formats = DateUtil.createDateFormatsForLocaleAndTimeZone(locale, timezone);
            return DateUtil.parseWithFormats(dateString, formats);
        }
        return date;
    }

    static Date parseWithFormats(String input, DateFormat[] formats) throws ParseException {
        ParseException parseException = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(input);
            }
            catch (ParseException ex) {
                parseException = ex;
                continue;
            }
        }
        if (parseException == null) {
            throw new IllegalStateException("No dateformats found that can be used for parsing '" + input + "'");
        }
        throw parseException;
    }

    static DateFormat[] createDateFormatsForLocaleAndTimeZone(Locale locale, TimeZone timeZone) {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        DateUtil.addDateTimeFormatsToList(locale, timeZone, formats);
        DateUtil.addDateFormatsToList(locale, timeZone, formats);
        return formats.toArray(new DateFormat[formats.size()]);
    }

    static void addDateFormatsToList(Locale locale, TimeZone timeZone, List<DateFormat> formats) {
        for (int dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
            df.setTimeZone(timeZone);
            formats.add(df);
        }
    }

    static void addDateTimeFormatsToList(Locale locale, TimeZone timeZone, List<DateFormat> formats) {
        for (int dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            for (int timeStyle = 0; timeStyle <= 3; ++timeStyle) {
                DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                if (timeZone != null) {
                    df.setTimeZone(timeZone);
                }
                formats.add(df);
            }
        }
    }
}

