/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.ChangeSetReader;
import hudson.plugins.tfs.ChangeSetWriter;
import hudson.plugins.tfs.PluginImpl;
import hudson.plugins.tfs.TeamFoundationServerScm;
import hudson.plugins.tfs.TfTool;
import hudson.plugins.tfs.actions.CheckoutAction;
import hudson.plugins.tfs.browsers.TeamFoundationServerRepositoryBrowser;
import hudson.plugins.tfs.model.Server;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.util.Scrambler;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamFoundationServerScm
extends SCM {
    private final String serverUrl;
    private final String projectPath;
    private final String localPath;
    private final String workspaceName;
    private final String userPassword;
    private final String userName;
    private final boolean useUpdate;
    private TeamFoundationServerRepositoryBrowser repositoryBrowser;
    private transient String normalizedWorkspaceName;

    @DataBoundConstructor
    public TeamFoundationServerScm(String serverUrl, String projectPath, String localPath, boolean useUpdate, String workspaceName, String userName, String userPassword) {
        this.serverUrl = serverUrl;
        this.projectPath = projectPath;
        this.useUpdate = useUpdate;
        this.localPath = Util.fixEmptyAndTrim((String)localPath) == null ? "." : localPath;
        this.workspaceName = Util.fixEmptyAndTrim((String)workspaceName) == null ? "Hudson-${JOB_NAME}" : workspaceName;
        this.userName = userName;
        this.userPassword = Scrambler.scramble((String)userPassword);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public String getUserPassword() {
        return Scrambler.descramble((String)this.userPassword);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNormalizedWorkspaceName(AbstractProject<?, ?> project) {
        if (this.normalizedWorkspaceName == null) {
            this.normalizedWorkspaceName = this.workspaceName;
            Matcher matcher = Pattern.compile("\\$\\{JOB_NAME\\}", 2).matcher(this.normalizedWorkspaceName);
            if (matcher.find()) {
                this.normalizedWorkspaceName = matcher.replaceAll(project.getName());
            }
            if ((matcher = Pattern.compile("\\$\\{USER_NAME\\}", 2).matcher(this.normalizedWorkspaceName)).find()) {
                this.normalizedWorkspaceName = matcher.replaceAll(System.getProperty("user.name"));
            }
        }
        return this.normalizedWorkspaceName;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspaceFilePath, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, (TaskListener)listener, workspaceFilePath));
        CheckoutAction action = new CheckoutAction(this.getNormalizedWorkspaceName(build.getProject()), this.projectPath, this.localPath, this.useUpdate);
        try {
            List list = action.checkout(server, workspaceFilePath, build.getPreviousBuild() != null ? build.getPreviousBuild().getTimestamp() : null);
            ChangeSetWriter writer = new ChangeSetWriter();
            writer.write(list, changelogFile);
        }
        catch (ParseException pe) {
            listener.fatalError(pe.getMessage());
            throw new AbortException();
        }
        return true;
    }

    public boolean pollChanges(AbstractProject hudsonProject, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lastBuild = hudsonProject.getLastBuild();
        if (lastBuild == null) {
            return true;
        }
        Server server = this.createServer(new TfTool(this.getDescriptor().getTfExecutable(), launcher, listener, workspace));
        try {
            return server.getProject(this.projectPath).getDetailedHistory(lastBuild.getTimestamp(), Calendar.getInstance()).size() > 0;
        }
        catch (ParseException pe) {
            listener.fatalError(pe.getMessage());
            throw new AbortException();
        }
    }

    protected Server createServer(TfTool tool) {
        return new Server(tool, this.getServerUrl(), this.getUserName(), this.getUserPassword());
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean supportsPolling() {
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeSetReader();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return workspace.child(this.localPath);
    }

    public TeamFoundationServerRepositoryBrowser getBrowser() {
        return this.repositoryBrowser;
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.TFS_DESCRIPTOR;
    }

    static /* synthetic */ TeamFoundationServerRepositoryBrowser access$002(TeamFoundationServerScm x0, TeamFoundationServerRepositoryBrowser x1) {
        x0.repositoryBrowser = x1;
        return x0.repositoryBrowser;
    }
}

