/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.DateUtil;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BriefHistoryCommand
extends AbstractCommand
implements ParseableCommand<List<ChangeSet>> {
    static final Pattern CHANGESET_PATTERN = Pattern.compile("^\\d*\\s+\\S+\\s+.*");
    static final Pattern SEPARATOR_PATTERN = Pattern.compile("(-+)(\\s+)(-+)(\\s+)(-+)(\\s+)(-+)");
    private final String projectPath;
    private final Calendar toTimestamp;
    private final Calendar fromTimestamp;

    public BriefHistoryCommand(ServerConfigurationProvider provider, String projectPath, Calendar fromTimestamp, Calendar toTimestamp) {
        super(provider);
        this.projectPath = projectPath;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
    }

    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("history");
        arguments.add(this.projectPath);
        arguments.add("/noprompt");
        arguments.add(String.format("/version:D%s~D%s", ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).format(this.fromTimestamp.getTime()), ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).format(this.toTimestamp.getTime())));
        arguments.add("/recursive");
        arguments.add("/format:brief");
        this.addServerArgument((ArgumentListBuilder)arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    public List<ChangeSet> parse(Reader consoleReader) throws ParseException, IOException {
        ArrayList<ChangeSet> list = new ArrayList<ChangeSet>();
        int[] colStart = new int[4];
        int[] colLength = new int[4];
        BufferedReader reader = new BufferedReader(consoleReader);
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = SEPARATOR_PATTERN.matcher(line);
            if (matcher.matches()) {
                for (int i = 0; i < colLength.length - 1; ++i) {
                    colLength[i] = colStart[i] + matcher.group(i * 2 + 1).length();
                    colStart[i + 1] = colLength[i] + matcher.group(i * 2 + 2).length();
                }
                break;
            }
            line = reader.readLine();
        }
        line = reader.readLine();
        while (line != null) {
            ChangeSet changeset;
            if (CHANGESET_PATTERN.matcher(line).matches() && (changeset = new ChangeSet(line.substring(colStart[0], colLength[0]).trim(), DateUtil.parseDate((String)line.substring(colStart[2], colLength[2]).trim()), line.substring(colStart[1], colLength[1]).trim(), line.substring(colStart[3]))).getDate().after(this.fromTimestamp.getTime())) {
                list.add(changeset);
            }
            line = reader.readLine();
        }
        return list;
    }
}

