/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.plugins.tfs.TfTool;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.Workspaces;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class Server
implements ServerConfigurationProvider {
    private final String url;
    private final String userName;
    private final String userPassword;
    private Workspaces workspaces;
    private Map<String, Project> projects = new HashMap();
    private final TfTool tool;

    public Server(TfTool tool, String url, String username, String password) {
        this.tool = tool;
        this.url = url;
        this.userName = username;
        this.userPassword = password;
    }

    Server(String url) {
        this(null, url, null, null);
    }

    public Project getProject(String projectPath) {
        if (!this.projects.containsKey(projectPath)) {
            this.projects.put(projectPath, new Project(this, projectPath));
        }
        return (Project)this.projects.get(projectPath);
    }

    public Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new Workspaces(this);
        }
        return this.workspaces;
    }

    public Reader execute(MaskedArgumentListBuilder arguments) throws IOException, InterruptedException {
        return this.tool.execute(arguments.toCommandArray(), arguments.toMaskArray());
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }
}

