/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.actions;

import hudson.FilePath;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.model.Project;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.Workspace;
import hudson.plugins.tfs.model.Workspaces;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutAction {
    private final String workspaceName;
    private final String projectPath;
    private final String localFolder;
    private final boolean useUpdate;

    public CheckoutAction(String workspaceName, String projectPath, String localFolder, boolean useUpdate) {
        this.workspaceName = workspaceName;
        this.projectPath = projectPath;
        this.localFolder = localFolder;
        this.useUpdate = useUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeSet> checkout(Server server, FilePath workspacePath, Calendar lastBuildTimestamp) throws IOException, InterruptedException, ParseException {
        Workspace workspace = null;
        Workspaces workspaces = server.getWorkspaces();
        Project project = server.getProject(this.projectPath);
        try {
            if (!workspaces.exists(this.workspaceName)) {
                FilePath localFolderPath = workspacePath.child(this.localFolder);
                if (!this.useUpdate && localFolderPath.exists()) {
                    localFolderPath.deleteContents();
                }
                workspace = workspaces.newWorkspace(this.workspaceName);
                workspace.mapWorkfolder(project, this.localFolder);
            } else {
                workspace = workspaces.getWorkspace(this.workspaceName);
            }
            project.getFiles(this.localFolder);
            if (lastBuildTimestamp != null) {
                List list = project.getDetailedHistory(lastBuildTimestamp, Calendar.getInstance());
                return list;
            }
        }
        finally {
            if (!this.useUpdate && workspace != null) {
                workspace.unmapWorkfolder(this.localFolder);
                workspaces.deleteWorkspace(workspace);
            }
        }
        return new ArrayList<ChangeSet>();
    }
}

