/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateUtil {
    public static final ThreadLocal<SimpleDateFormat> TFS_DATETIME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            return dateFormat;
        }
    };

    private DateUtil() {
    }

    public static Date parseDate(String dateString) throws ParseException {
        Date date = null;
        try {
            date = new Date(Date.parse(dateString));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (date == null) {
            DateFormat[] formats = DateUtil.createDateFormatsForLocaleAndTimeZone(null, null);
            return DateUtil.parseWithFormats(dateString, formats);
        }
        return date;
    }

    static Date parseWithFormats(String input, DateFormat[] formats) throws ParseException {
        ParseException parseException = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(input);
            }
            catch (ParseException ex) {
                parseException = ex;
                continue;
            }
        }
        throw parseException;
    }

    static DateFormat[] createDateFormatsForLocaleAndTimeZone(Locale locale, TimeZone timeZone) {
        int dateStyle;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        for (dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            for (int timeStyle = 0; timeStyle <= 3; ++timeStyle) {
                DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                if (timeZone != null) {
                    df.setTimeZone(timeZone);
                }
                formats.add(df);
            }
        }
        for (dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
            df.setTimeZone(timeZone);
            formats.add(df);
        }
        return formats.toArray(new DateFormat[formats.size()]);
    }
}

