/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextTableParser {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("(-+)");
    private final BufferedReader reader;
    private List<ColumnRange> columns;
    private String currentLine;
    private final int optionalColumnCount;
    private int lastMandatoryColumnStart;

    public TextTableParser(Reader reader) throws IOException {
        this(reader, 0);
    }

    public TextTableParser(Reader reader, int optionalColumnCount) throws IOException {
        this.reader = new BufferedReader(reader);
        this.optionalColumnCount = optionalColumnCount;
        this.init();
    }

    private void init() throws IOException {
        String line = this.reader.readLine();
        this.columns = new ArrayList<ColumnRange>();
        while (line != null) {
            Matcher matcher = SEPARATOR_PATTERN.matcher(line);
            if (matcher.find()) {
                do {
                    this.columns.add(new ColumnRange(matcher.start(), matcher.end()));
                } while (matcher.find());
                break;
            }
            line = this.reader.readLine();
        }
        if (this.columns.size() > 0) {
            this.lastMandatoryColumnStart = this.columns.get(this.columns.size() - 1 - this.optionalColumnCount).start;
        }
    }

    public int getColumnCount() throws IOException {
        return this.columns.size();
    }

    public String getColumn(int index) throws IOException {
        if (this.currentLine == null) {
            throw new IllegalStateException("There is no active row.");
        }
        ColumnRange columnRange = this.columns.get(index);
        if (this.currentLine.length() < columnRange.start) {
            return null;
        }
        if (this.currentLine.length() < columnRange.end) {
            return this.currentLine.substring(columnRange.start).trim();
        }
        return this.currentLine.substring(columnRange.start, columnRange.end).trim();
    }

    public boolean nextRow() throws IOException {
        do {
            this.currentLine = this.reader.readLine();
        } while (this.currentLine != null && this.currentLine.length() < this.lastMandatoryColumnStart);
        return this.currentLine != null;
    }

    private static class ColumnRange {
        private final int start;
        private final int end;

        public ColumnRange(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

