/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.ForkOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class TfTool {
    static final int SUCCESS_EXIT_CODE = 0;
    static final int PARTIAL_SUCCESS_EXIT_CODE = 1;
    private Launcher launcher;
    private TaskListener listener;
    private FilePath workspace;
    private final String executable;
    private static final Logger LOGGER = Logger.getLogger(TfTool.class.getName());

    public TfTool(String executable, Launcher launcher, TaskListener listener, FilePath workspace) {
        this.executable = executable;
        this.launcher = launcher;
        this.listener = listener;
        this.workspace = workspace;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public String getHostname() throws IOException, InterruptedException {
        try {
            return (String)this.workspace.act((Callable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (UnknownHostException e) {
            LOGGER.warning("Could not resolve local hostname needed to list workspaces. " + e);
            return null;
        }
    }

    public Reader execute(String[] arguments) throws IOException, InterruptedException {
        return this.execute(arguments, null);
    }

    public Reader execute(String[] arguments, boolean[] masks) throws IOException, InterruptedException {
        String[] toolArguments = new String[arguments.length + 1];
        toolArguments[0] = this.executable;
        for (int i = 0; i < arguments.length; ++i) {
            toolArguments[i + 1] = arguments[i];
        }
        boolean[] toolMasks = new boolean[arguments.length + 1];
        if (masks != null) {
            toolMasks = new boolean[masks.length + 1];
            toolMasks[0] = false;
            for (int i = 0; i < masks.length; ++i) {
                toolMasks[i + 1] = masks[i];
            }
        }
        ByteArrayOutputStream consoleStream = new ByteArrayOutputStream();
        Proc proc = this.launcher.launch(toolArguments, toolMasks, new String[0], null, (OutputStream)new ForkOutputStream((OutputStream)consoleStream, (OutputStream)this.listener.getLogger()), this.workspace);
        consoleStream.close();
        int result = proc.join();
        LOGGER.fine(String.format("The TFS command '%s' returned with an error code of %d", toolArguments[1], result));
        if (result == 0 || result == 1) {
            return new InputStreamReader(new ByteArrayInputStream(consoleStream.toByteArray()));
        }
        this.listener.fatalError(String.format("Executable returned an unexpected result code [%d]", result));
        throw new AbortException();
    }
}

