/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.Util;
import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ListWorkspacesCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.Workspace;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import hudson.plugins.tfs.util.TextTableParser;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWorkspacesCommand
extends AbstractCommand
implements ParseableCommand<List<Workspace>> {
    private final WorkspaceFactory factory;
    private final String computer;

    public ListWorkspacesCommand(WorkspaceFactory factory, ServerConfigurationProvider provider) {
        this(factory, provider, null);
    }

    public ListWorkspacesCommand(WorkspaceFactory factory, ServerConfigurationProvider config, String computer) {
        super(config);
        this.computer = computer;
        this.factory = factory;
    }

    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("workspaces");
        arguments.add("-format:brief");
        if (Util.fixEmpty((String)this.computer) != null) {
            arguments.add(String.format("-computer:%s", this.computer));
        }
        this.addServerArgument((ArgumentListBuilder)arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    public List<Workspace> parse(Reader consoleReader) throws IOException {
        ArrayList<Workspace> list = new ArrayList<Workspace>();
        TextTableParser parser = new TextTableParser(consoleReader, 1);
        while (parser.nextRow()) {
            Workspace workspace = this.factory.createWorkspace(parser.getColumn(0), parser.getColumn(2), parser.getColumn(1), Util.fixNull((String)parser.getColumn(3)));
            list.add(workspace);
        }
        return list;
    }
}

