/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.DateUtil;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedHistoryCommand
extends AbstractCommand
implements ParseableCommand<List<ChangeSet>> {
    private static final String CHANGESET_SEPERATOR = "------------";
    private static final Pattern PATTERN_CHANGESET = Pattern.compile("^[^:]*:[ \t]([0-9]*)\n[^:]*:[ \t](.*)\n[^:]*:[ \t](.*)\n[^:]*:(?s)(.*)\n\n[^\n :]*:(?=\n  )(.*)\n\n");
    private static final Pattern PATTERN_ITEM = Pattern.compile("\n  ([^$]+) (\\$/.*)");
    private final String projectPath;
    private final Calendar fromTimestamp;
    private final Calendar toTimestamp;

    public DetailedHistoryCommand(ServerConfigurationProvider provider, String projectPath, Calendar fromTimestamp, Calendar toTimestamp) {
        super(provider);
        this.projectPath = projectPath;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
    }

    @Override
    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("history");
        arguments.add(this.projectPath);
        arguments.add("-noprompt");
        arguments.add(String.format("-version:D%s~D%s", DateUtil.TFS_DATETIME_FORMATTER.get().format(this.fromTimestamp.getTime()), DateUtil.TFS_DATETIME_FORMATTER.get().format(this.toTimestamp.getTime())));
        arguments.add("-recursive");
        arguments.add("-format:detailed");
        this.addServerArgument(arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    @Override
    public List<ChangeSet> parse(Reader reader) throws IOException, ParseException {
        return this.parseDetailedHistoryOutput(new BufferedReader(reader), this.fromTimestamp.getTime());
    }

    private List<ChangeSet> parseDetailedHistoryOutput(BufferedReader consoleReader, Date lastBuildDate) throws IOException, ParseException {
        ChangeSet changeSet;
        String line;
        ArrayList<ChangeSet> list = new ArrayList<ChangeSet>();
        StringBuilder builder = new StringBuilder();
        int linecount = 0;
        boolean foundAtLeastOneChangeSet = false;
        while ((line = consoleReader.readLine()) != null) {
            ++linecount;
            if (line.startsWith(CHANGESET_SEPERATOR)) {
                foundAtLeastOneChangeSet = true;
                if (linecount <= 1) continue;
                changeSet = this.parseChangeSetOutput(builder.toString(), lastBuildDate);
                if (changeSet != null) {
                    list.add(changeSet);
                }
                builder.setLength(0);
                continue;
            }
            builder.append(line).append('\n');
        }
        if (foundAtLeastOneChangeSet && (changeSet = this.parseChangeSetOutput(builder.toString(), lastBuildDate)) != null) {
            list.add(changeSet);
        }
        Collections.reverse(list);
        return list;
    }

    private ChangeSet parseChangeSetOutput(String changeSetString, Date lastBuildDate) throws ParseException {
        ChangeSet changeset = null;
        Matcher m = PATTERN_CHANGESET.matcher(changeSetString);
        if (m.find()) {
            String revision = m.group(1);
            String userName = m.group(2).trim();
            Date modifiedTime = DateUtil.parseDate(m.group(3));
            if (modifiedTime.compareTo(lastBuildDate) < 0) {
                return null;
            }
            String comment = m.group(4).replaceAll("\n  ", "\n");
            if (comment.length() > 0) {
                comment = comment.trim();
            }
            Matcher itemMatcher = PATTERN_ITEM.matcher(m.group(5));
            while (itemMatcher.find()) {
                if (changeset == null) {
                    changeset = new ChangeSet(revision, modifiedTime, userName, comment);
                }
                String path = itemMatcher.group(2);
                String action = itemMatcher.group(1).trim();
                if (!path.startsWith("$/")) {
                    throw new ParseException("Parse error. Mistakenly identified \"" + path + "\" as an item, but it does not appear to " + "be a valid TFS path.  Please report this as a bug.  Changeset" + "data = \"\n" + changeSetString + "\n\".", itemMatcher.start());
                }
                changeset.getItems().add(new ChangeSet.Item(path, action));
            }
        }
        if (changeset == null) {
            throw new ParseException("Parse error. Unable to find an item within a changeset.  Please report this as a bug.  Changesetdata = \"\n" + changeSetString + "\n\".", 0);
        }
        return changeset;
    }
}

