/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.Util;
import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.plugins.tfs.util.DateUtil;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import hudson.plugins.tfs.util.TextTableParser;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BriefHistoryCommand
extends AbstractCommand
implements ParseableCommand<List<ChangeSet>> {
    private final String projectPath;
    private final Calendar toTimestamp;
    private final Calendar fromTimestamp;

    public BriefHistoryCommand(ServerConfigurationProvider provider, String projectPath, Calendar fromTimestamp, Calendar toTimestamp) {
        super(provider);
        this.projectPath = projectPath;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
    }

    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("history");
        arguments.add(this.projectPath);
        arguments.add("-noprompt");
        arguments.add(String.format("-version:D%s~D%s", ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).format(this.fromTimestamp.getTime()), ((SimpleDateFormat)DateUtil.TFS_DATETIME_FORMATTER.get()).format(this.toTimestamp.getTime())));
        arguments.add("-recursive");
        arguments.add("-format:brief");
        this.addServerArgument((ArgumentListBuilder)arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    public List<ChangeSet> parse(Reader consoleReader) throws ParseException, IOException {
        ArrayList<ChangeSet> list = new ArrayList<ChangeSet>();
        TextTableParser parser = new TextTableParser((Reader)new BufferedReader(consoleReader), 1);
        while (parser.nextRow()) {
            ChangeSet changeset = new ChangeSet(parser.getColumn(0), DateUtil.parseDate((String)parser.getColumn(2)), parser.getColumn(1), Util.fixNull((String)parser.getColumn(3)));
            if (!changeset.getDate().after(this.fromTimestamp.getTime())) continue;
            list.add(changeset);
        }
        return list;
    }
}

