/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.browsers;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.plugins.tfs.PluginImpl;
import hudson.plugins.tfs.TeamFoundationServerScm;
import hudson.plugins.tfs.browsers.TeamFoundationServerRepositoryBrowser;
import hudson.plugins.tfs.browsers.TeamSystemWebAccessBrowser;
import hudson.plugins.tfs.model.ChangeSet;
import hudson.scm.EditType;
import hudson.scm.SCM;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class TeamSystemWebAccessBrowser
extends TeamFoundationServerRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String url;

    @DataBoundConstructor
    public TeamSystemWebAccessBrowser(String urlExample) {
        this.url = Util.fixEmpty((String)urlExample);
    }

    public String getUrl() {
        return this.url;
    }

    private String getServerConfiguration(ChangeSet changeset) {
        AbstractProject project = changeset.getParent().build.getProject();
        SCM scm = project.getScm();
        if (scm instanceof TeamFoundationServerScm) {
            return ((TeamFoundationServerScm)scm).getServerUrl((Run)changeset.getParent().build);
        }
        throw new IllegalStateException("TFS repository browser used on a non TFS SCM");
    }

    private String getBaseUrlString(ChangeSet changeSet) {
        String baseUrl = this.url != null ? DescriptorImpl.getBaseUrl((String)this.url) : String.format("%s/", this.getServerConfiguration(changeSet));
        return baseUrl;
    }

    public URL getChangeSetLink(ChangeSet changeSet) throws IOException {
        return new URL(String.format("%scs.aspx?cs=%s", this.getBaseUrlString(changeSet), changeSet.getVersion()));
    }

    public URL getFileLink(ChangeSet.Item item) throws IOException {
        return new URL(String.format("%sview.aspx?path=%s&cs=%s", this.getBaseUrlString(item.getParent()), item.getPath(), item.getParent().getVersion()));
    }

    public URL getDiffLink(ChangeSet.Item item) throws IOException {
        ChangeSet parent = item.getParent();
        if (item.getEditType() != EditType.EDIT) {
            return null;
        }
        try {
            return new URL(String.format("%sdiff.aspx?opath=%s&ocs=%s&mpath=%s&mcs=%s", this.getBaseUrlString(parent), item.getPath(), this.getPreviousChangeSetVersion(parent), item.getPath(), parent.getVersion()));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private String getPreviousChangeSetVersion(ChangeSet changeset) throws NumberFormatException {
        return Integer.toString(Integer.parseInt(changeset.getVersion()) - 1);
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.TSWA_DESCRIPTOR;
    }
}

