/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.commands;

import hudson.plugins.tfs.commands.AbstractCommand;
import hudson.plugins.tfs.commands.ParseableCommand;
import hudson.plugins.tfs.commands.ServerConfigurationProvider;
import hudson.plugins.tfs.model.WorkspaceMapping;
import hudson.plugins.tfs.util.MaskedArgumentListBuilder;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetWorkspaceMappingsCommand
extends AbstractCommand
implements ParseableCommand<List<WorkspaceMapping>> {
    private static final Pattern PATTERN_WORKFOLDERMAPPING = Pattern.compile("\\s*(.*):\\s(.*)");
    private final String workspace;

    public GetWorkspaceMappingsCommand(ServerConfigurationProvider config, String workspace) {
        super(config);
        this.workspace = workspace;
    }

    public MaskedArgumentListBuilder getArguments() {
        MaskedArgumentListBuilder arguments = new MaskedArgumentListBuilder();
        arguments.add("workfold");
        arguments.add("-workspace:" + this.workspace);
        this.addServerArgument((ArgumentListBuilder)arguments);
        this.addLoginArgument(arguments);
        return arguments;
    }

    public List<WorkspaceMapping> parse(Reader consoleReader) throws ParseException, IOException {
        ArrayList<WorkspaceMapping> mappings = new ArrayList<WorkspaceMapping>();
        BufferedReader reader = new BufferedReader(consoleReader);
        reader.readLine();
        reader.readLine();
        reader.readLine();
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = PATTERN_WORKFOLDERMAPPING.matcher(line);
            if (matcher.find()) {
                mappings.add(new WorkspaceMapping(matcher.group(1), matcher.group(2)));
            }
            line = reader.readLine();
        }
        return mappings;
    }
}

