/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.utils;

import hudson.model.Computer;
import hudson.model.Hudson;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPluginImpl;
import org.jvnet.hudson.plugins.thinbackup.backup.BackupSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final int COMPUTER_TIMEOUT_WAIT = 500;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm");

    public static void waitUntilIdle() {
        boolean running;
        Computer[] computers = Hudson.getInstance().getComputers();
        do {
            running = false;
            for (Computer computer : computers) {
                if (computer.countBusy() == 0) continue;
                running = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        } while (running);
    }

    public static File getReferencedFullBackup(File diffBackup) {
        if (diffBackup.getName().startsWith(ThinBackupPeriodicWork.BackupType.FULL.toString())) {
            return diffBackup;
        }
        IOFileFilter prefixFilter = FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.FULL.toString());
        prefixFilter = FileFilterUtils.andFileFilter((IOFileFilter)prefixFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        List<File> backups = Arrays.asList(new File(diffBackup.getParent()).listFiles((FilenameFilter)prefixFilter));
        if (backups.isEmpty()) {
            return null;
        }
        File referencedFullBackup = null;
        Date curModifiedDate = new Date(diffBackup.lastModified());
        Date closestPreviousBackupDate = new Date(0L);
        for (File fullBackupDir : backups) {
            Date tmpModifiedDate = new Date(fullBackupDir.lastModified());
            if (!tmpModifiedDate.before(curModifiedDate) || !tmpModifiedDate.after(closestPreviousBackupDate)) continue;
            closestPreviousBackupDate = tmpModifiedDate;
            referencedFullBackup = fullBackupDir;
        }
        return referencedFullBackup;
    }

    public static File getFormattedDirectory(File directory, ThinBackupPeriodicWork.BackupType backupType, Date date) {
        File formattedDirectory = new File(directory, String.format("%s-%s", backupType, DATE_FORMAT.format(date)));
        return formattedDirectory;
    }

    public static List<File> getReferencingDiffBackups(File fullBackup) {
        ArrayList<File> diffBackups = new ArrayList<File>();
        if (fullBackup.getName().startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
            return diffBackups;
        }
        IOFileFilter prefixFilter = FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.DIFF.toString());
        prefixFilter = FileFilterUtils.andFileFilter((IOFileFilter)prefixFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        List<File> allDiffBackups = Arrays.asList(new File(fullBackup.getParent()).listFiles((FilenameFilter)prefixFilter));
        for (File diffBackup : allDiffBackups) {
            File tmpFullBackup = Utils.getReferencedFullBackup((File)diffBackup);
            if (tmpFullBackup == null || !tmpFullBackup.getAbsolutePath().equals(fullBackup.getAbsolutePath())) continue;
            diffBackups.add(diffBackup);
        }
        return diffBackups;
    }

    public static List<BackupSet> getAvailableValidBackupSets() {
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.getInstance();
        IOFileFilter prefixFilter = FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.FULL.toString());
        prefixFilter = FileFilterUtils.andFileFilter((IOFileFilter)prefixFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        List<File> backups = Arrays.asList(new File(plugin.getBackupPath()).listFiles((FilenameFilter)prefixFilter));
        ArrayList<BackupSet> sets = new ArrayList<BackupSet>();
        for (File backup : backups) {
            BackupSet set = new BackupSet(backup);
            if (!set.isValid()) continue;
            sets.add(set);
        }
        Collections.sort(sets);
        return sets;
    }

    public static List<String> getAvailableBackups() {
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.getInstance();
        IOFileFilter filter = FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.FULL.toString());
        filter = FileFilterUtils.orFileFilter((IOFileFilter)filter, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.DIFF.toString()));
        filter = FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        String[] backups = new File(plugin.getBackupPath()).list((FilenameFilter)filter);
        ArrayList<String> list = new ArrayList<String>(backups.length);
        for (String name : backups) {
            list.add(name.replaceFirst(String.format("(%s|%s)-", ThinBackupPeriodicWork.BackupType.FULL, ThinBackupPeriodicWork.BackupType.DIFF), ""));
        }
        Collections.sort(list);
        return list;
    }
}

