/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.TaskListener;
import hudson.scheduler.CronTab;
import hudson.triggers.Trigger;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPluginImpl;
import org.jvnet.hudson.plugins.thinbackup.restore.HudsonRestore;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ThinBackupMgmtLink
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");

    public String getDisplayName() {
        return "ThinBackup";
    }

    public String getIconFileName() {
        return "package.gif";
    }

    public String getUrlName() {
        return "thinBackup";
    }

    public String getDescription() {
        return "Backup your global and job specific configuration.";
    }

    public void doBackupManual(StaplerRequest res, StaplerResponse rsp) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        ThinBackupPeriodicWork manualBackupWorker = new ThinBackupPeriodicWork(){

            protected void execute(TaskListener arg0) throws IOException, InterruptedException {
                this.backupNow(ThinBackupPeriodicWork.BackupType.FULL);
            }
        };
        Trigger.timer.schedule((TimerTask)((Object)manualBackupWorker), 0L);
        LOGGER.info("Manual backup finished");
        rsp.sendRedirect(res.getContextPath() + "/thinBackup");
    }

    public void doRestore(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="restoreBackupFrom") String restoreBackupFrom) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        Hudson hudson = Hudson.getInstance();
        hudson.doQuietDown();
        LOGGER.fine("Wait until executors are idle to perform restore.");
        Utils.waitUntilIdle();
        File hudsonHome = Hudson.getInstance().getRootDir();
        HudsonRestore hudsonRestore = new HudsonRestore(hudsonHome, ThinBackupPluginImpl.getInstance().getBackupPath(), restoreBackupFrom);
        hudsonRestore.restore();
        hudson.doCancelQuietDown();
        LOGGER.info("Restore finished.");
        rsp.sendRedirect(res.getContextPath() + "/thinBackup");
    }

    public void doSaveSettings(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="backupPath") String backupPath, @QueryParameter(value="fullBackupSchedule") String fullBackupSchedule, @QueryParameter(value="diffBackupSchedule") String diffBackupSchedule, @QueryParameter(value="nrMaxStoredFull") String nrMaxStoredFull, @QueryParameter(value="cleanupDiff") boolean cleanupDiff) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.getInstance();
        plugin.setBackupPath(backupPath);
        plugin.setFullBackupSchedule(fullBackupSchedule);
        plugin.setDiffBackupSchedule(diffBackupSchedule);
        plugin.setNrMaxStoredFull(nrMaxStoredFull);
        plugin.setCleanupDiff(cleanupDiff);
        plugin.save();
        LOGGER.fine("Save backup settings done.");
        rsp.sendRedirect(res.getContextPath() + "/thinBackup");
    }

    public FormValidation doCheckBackupPath(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="backupPath") String backupPath) {
        if (backupPath == null || backupPath.isEmpty()) {
            return FormValidation.error((String)"'Backup Path' is not mandatory.");
        }
        File backupdir = new File(backupPath);
        if (!backupdir.exists()) {
            return FormValidation.warning((String)"The given directory does not exist, it will be created during the first run.");
        }
        if (!backupdir.isDirectory()) {
            return FormValidation.error((String)"A file with this name already exists.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckFullBackupSchedule(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="fullBackupSchedule") String backupSchedule) {
        return this.validateCronSchedule(backupSchedule);
    }

    public FormValidation doCheckDiffBackupSchedule(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="diffBackupSchedule") String backupSchedule) {
        return this.validateCronSchedule(backupSchedule);
    }

    private FormValidation validateCronSchedule(String backupTime) {
        if (backupTime != null && !backupTime.isEmpty()) {
            String message;
            try {
                message = new CronTab(backupTime).checkSanity();
            }
            catch (ANTLRException e) {
                return FormValidation.error((String)e.getMessage());
            }
            if (message != null) {
                return FormValidation.warning((String)message);
            }
            return FormValidation.ok();
        }
        return FormValidation.ok();
    }

    public ThinBackupPluginImpl getConfiguration() {
        return ThinBackupPluginImpl.getInstance();
    }

    public List<String> getAvailableBackups() {
        return Utils.getAvailableBackups();
    }
}

