/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.scheduler.CronTab;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPluginImpl;
import org.jvnet.hudson.plugins.thinbackup.backup.HudsonBackup;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

@Extension
public class ThinBackupPeriodicWork
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");

    public ThinBackupPeriodicWork() {
        super("ThinBackup Worker Thread");
    }

    public long getRecurrencePeriod() {
        return 60000L;
    }

    protected void execute(TaskListener arg0) throws IOException, InterruptedException {
        BackupType type = this.executeNow();
        if (type != BackupType.NONE) {
            this.backupNow(type);
        }
    }

    protected void backupNow(BackupType type) {
        try {
            int maxStoredFull;
            ThinBackupPluginImpl plugin = ThinBackupPluginImpl.getInstance();
            String backupPath = plugin.getBackupPath();
            boolean cleanupDiff = plugin.isCleanupDiff();
            String noMaxStoredFull = plugin.getNrMaxStoredFull();
            if (StringUtils.isEmpty((String)noMaxStoredFull)) {
                maxStoredFull = -1;
            } else {
                try {
                    maxStoredFull = Integer.parseInt(noMaxStoredFull);
                }
                catch (NumberFormatException nfe) {
                    maxStoredFull = -1;
                }
            }
            if (!StringUtils.isEmpty((String)backupPath)) {
                Hudson hudson = Hudson.getInstance();
                hudson.doQuietDown();
                LOGGER.fine("Wait until executors are idle to perform backup.");
                Utils.waitUntilIdle();
                new HudsonBackup(backupPath, Hudson.getInstance().getRootDir(), type, maxStoredFull, cleanupDiff).run();
                hudson.doCancelQuietDown();
            } else {
                LOGGER.warning("ThinBackup is not configured yet: No backup path set.");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private BackupType executeNow() {
        long currentTime = System.currentTimeMillis();
        long fullDelay = this.calculateDelay(currentTime, BackupType.FULL);
        long diffDelay = this.calculateDelay(currentTime, BackupType.DIFF);
        BackupType res = BackupType.NONE;
        long delay = Long.MAX_VALUE;
        if (fullDelay == -1L && diffDelay == -1L) {
            return BackupType.NONE;
        }
        if (fullDelay != -1L && diffDelay == -1L) {
            res = BackupType.FULL;
            delay = fullDelay;
        } else if (fullDelay == -1L && diffDelay != -1L) {
            res = BackupType.DIFF;
            delay = diffDelay;
        } else {
            res = BackupType.DIFF;
            delay = diffDelay;
            if (fullDelay <= diffDelay) {
                delay = fullDelay;
                res = BackupType.FULL;
            }
        }
        return delay < 60000L ? res : BackupType.NONE;
    }

    private long calculateDelay(long currentTime, BackupType backupType) {
        try {
            String cron = null;
            switch (backupType) {
                case FULL: {
                    cron = this.getFullCronTimeFromConfig();
                    break;
                }
                case DIFF: {
                    cron = this.getDiffCronTimeFromConfig();
                    break;
                }
                default: {
                    return -1L;
                }
            }
            if (StringUtils.isEmpty((String)cron)) {
                return -1L;
            }
            CronTab cronTab = new CronTab(cron);
            Calendar nextFullExecution = cronTab.ceil(currentTime);
            long delay = nextFullExecution.getTimeInMillis() - currentTime;
            LOGGER.fine(MessageFormat.format("current time: {0} next {3} execution: {1} delay [s]: {2}", new Object[]{new Date(currentTime), nextFullExecution.getTime(), TimeUnit2.MILLISECONDS.toSeconds(delay), backupType}));
            return delay;
        }
        catch (ANTLRException e) {
            LOGGER.warning(MessageFormat.format("Cannot parse the specified 'Backup schedule for {0} backups'. Check cron notation.", backupType.toString()));
            return -1L;
        }
    }

    private String getFullCronTimeFromConfig() {
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.getInstance();
        String backupTime = plugin.getFullBackupSchedule();
        return backupTime;
    }

    private String getDiffCronTimeFromConfig() {
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.getInstance();
        String backupTime = plugin.getDiffBackupSchedule();
        return backupTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackupType {
        NONE,
        FULL,
        DIFF;

    }
}

