/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.backup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupSet
implements Comparable<BackupSet> {
    private File fullBackup = null;
    private List<File> diffBackups = null;

    public BackupSet(File initial) {
        File tmpFull = null;
        if (initial.getName().startsWith(ThinBackupPeriodicWork.BackupType.FULL.toString())) {
            tmpFull = initial;
        } else if (initial.getName().startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
            tmpFull = Utils.getReferencedFullBackup(initial);
        }
        this.fullBackup = tmpFull;
        if (this.fullBackup != null) {
            this.diffBackups = Utils.getReferencingDiffBackups(this.fullBackup);
        } else if (initial.getName().startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
            this.diffBackups = new ArrayList<File>(1);
            this.diffBackups.add(initial);
        }
    }

    public boolean isValid() {
        return this.fullBackup != null;
    }

    public void delete() throws IOException {
        if (this.fullBackup != null) {
            FileUtils.deleteDirectory((File)this.fullBackup);
            this.fullBackup = null;
        }
        if (this.diffBackups != null) {
            for (File diffBackup : this.diffBackups) {
                FileUtils.deleteDirectory((File)diffBackup);
            }
            this.diffBackups = null;
        }
    }

    public File getFullBackup() {
        return this.fullBackup;
    }

    public List<File> getDiffBackups() {
        return this.diffBackups;
    }

    @Override
    public int compareTo(BackupSet other) {
        long otherLastModified;
        File otherFullBackup = other.getFullBackup();
        if (this.fullBackup == null && otherFullBackup == null) {
            return 0;
        }
        if (this.fullBackup == null) {
            return -1;
        }
        if (otherFullBackup == null) {
            return 1;
        }
        long thisLastModified = this.fullBackup.lastModified();
        if (thisLastModified == (otherLastModified = otherFullBackup.lastModified())) {
            return 0;
        }
        if (thisLastModified < otherLastModified) {
            return -1;
        }
        return 1;
    }
}

