/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.backup;

import hudson.PluginWrapper;
import hudson.model.Hudson;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.backup.BackupSet;
import org.jvnet.hudson.plugins.thinbackup.backup.DirectoryCleaner;
import org.jvnet.hudson.plugins.thinbackup.backup.PluginList;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

public class HudsonBackup {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    private static final String INSTALLED_PLUGINS_XML = "installedPlugins.xml";
    private static final String BUILDS_DIR_NAME = "Builds";
    private static final String JOBS_DIR = "jobs";
    private final File hudsonDirectory;
    private final File backupDirectory;
    private final ThinBackupPeriodicWork.BackupType backupType;
    private final Date latestFullBackupDate;
    private final boolean cleanupDiff;
    private final int nrMaxStoredFull;
    private final File backupRoot;

    public HudsonBackup(String backupRootPath, File hudsonHome, ThinBackupPeriodicWork.BackupType backupType, int nrMaxStoredFull, boolean cleanupDiff) {
        this.hudsonDirectory = hudsonHome;
        this.cleanupDiff = cleanupDiff;
        this.nrMaxStoredFull = nrMaxStoredFull;
        this.backupRoot = new File(backupRootPath);
        if (!this.backupRoot.exists()) {
            this.backupRoot.mkdir();
        }
        this.latestFullBackupDate = this.getLatestFullBackupDate(this.backupRoot);
        this.backupType = backupType == ThinBackupPeriodicWork.BackupType.DIFF && this.latestFullBackupDate == null ? ThinBackupPeriodicWork.BackupType.FULL : backupType;
        Date date = new Date();
        this.backupDirectory = Utils.getFormattedDirectory(this.backupRoot, backupType, date);
    }

    public boolean run() throws IOException {
        boolean res;
        LOGGER.info(MessageFormat.format("Performing {0} backup.", new Object[]{this.backupType}));
        if (!this.hudsonDirectory.exists() || !this.hudsonDirectory.isDirectory()) {
            throw new FileNotFoundException("No Hudson directory found, thus cannot trigger backup.");
        }
        if (!(this.backupDirectory.exists() && this.backupDirectory.isDirectory() || (res = this.backupDirectory.mkdirs()))) {
            throw new IOException("Could not create target directory.");
        }
        if (this.backupType == ThinBackupPeriodicWork.BackupType.NONE) {
            throw new IllegalStateException("Backup type must be FULL or DIFF.");
        }
        this.backupGlobalXmls();
        this.backupJobs();
        this.storePluginList();
        new DirectoryCleaner().clean(this.backupDirectory);
        if (this.backupType == ThinBackupPeriodicWork.BackupType.FULL) {
            if (this.nrMaxStoredFull > 0) {
                List<BackupSet> availableBackupSets = Utils.getAvailableValidBackupSets();
                while (availableBackupSets.size() > this.nrMaxStoredFull) {
                    BackupSet set = availableBackupSets.get(0);
                    set.delete();
                    availableBackupSets.remove(set);
                }
            }
            if (this.cleanupDiff) {
                File[] diffDirs;
                IOFileFilter filter = FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.DIFF.toString());
                filter = FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
                for (File diffDirToDelete : diffDirs = this.backupDirectory.getParentFile().listFiles((FilenameFilter)filter)) {
                    FileUtils.deleteDirectory((File)diffDirToDelete);
                }
            }
        }
        return true;
    }

    private void backupGlobalXmls() throws IOException {
        IOFileFilter suffixFileFilter = FileFilterUtils.suffixFileFilter((String)".xml");
        suffixFileFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFileFilter.FILE, (IOFileFilter)suffixFileFilter);
        suffixFileFilter = FileFilterUtils.andFileFilter((IOFileFilter)suffixFileFilter, (IOFileFilter)this.getDiffFilter());
        FileUtils.copyDirectory((File)this.hudsonDirectory, (File)this.backupDirectory, (FileFilter)suffixFileFilter);
    }

    private void backupJobs() throws IOException {
        String jobsPath = String.format("%s/%s", this.hudsonDirectory.getAbsolutePath(), JOBS_DIR);
        File jobsDirectory = new File(jobsPath);
        String jobsBackupPath = String.format("%s/%s", this.backupDirectory.getAbsolutePath(), JOBS_DIR);
        File jobsBackupDirectory = new File(jobsBackupPath);
        IOFileFilter filter = FileFilterUtils.suffixFileFilter((String)".xml");
        Hudson hudson = Hudson.getInstance();
        List<String> jobNames = hudson != null ? hudson.getJobNames() : Arrays.asList(jobsDirectory.list());
        IOFileFilter jobFilter = null;
        for (String jobName : jobNames) {
            List<String> builds;
            IOFileFilter nameFileFilter = FileFilterUtils.nameFileFilter((String)jobName);
            jobFilter = jobFilter == null ? nameFileFilter : FileFilterUtils.orFileFilter((IOFileFilter)filter, (IOFileFilter)nameFileFilter);
            File buildsDir = new File(new File(jobsDirectory, jobName), BUILDS_DIR_NAME);
            if (!buildsDir.exists() || !buildsDir.isDirectory() || (builds = Arrays.asList(buildsDir.list())) == null) continue;
            String buildsBackupPath = String.format("%s/%s/%s", jobsBackupPath, jobName, BUILDS_DIR_NAME);
            for (String build : builds) {
                File srcDir = new File(buildsDir, build);
                File destDir = new File(buildsBackupPath, build);
                IOFileFilter buildFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFileFilter.FILE, (IOFileFilter)this.getDiffFilter());
                FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)buildFilter);
            }
        }
        if (jobFilter != null) {
            jobFilter = FileFilterUtils.andFileFilter(jobFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            filter = FileFilterUtils.orFileFilter((IOFileFilter)filter, (IOFileFilter)jobFilter);
        }
        filter = FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)this.getDiffFilter());
        FileUtils.copyDirectory((File)jobsDirectory, (File)jobsBackupDirectory, (FileFilter)filter);
    }

    private void storePluginList() throws IOException {
        Hudson hudson = Hudson.getInstance();
        PluginList latestFullPlugins = null;
        if (this.backupType == ThinBackupPeriodicWork.BackupType.DIFF) {
            File latestFullBackupDir = Utils.getFormattedDirectory(this.backupDirectory.getParentFile(), ThinBackupPeriodicWork.BackupType.FULL, this.latestFullBackupDate);
            File pluginsOfLatestFull = new File(latestFullBackupDir, INSTALLED_PLUGINS_XML);
            latestFullPlugins = new PluginList(pluginsOfLatestFull);
            latestFullPlugins.load();
        }
        List installedPlugins = hudson != null ? hudson.getPluginManager().getPlugins() : Collections.emptyList();
        File pluginVersionList = new File(this.backupDirectory, INSTALLED_PLUGINS_XML);
        PluginList newPluginList = new PluginList(pluginVersionList);
        if (hudson != null) {
            newPluginList.add("Hudson core", Hudson.getVersion().toString());
        }
        for (PluginWrapper plugin : installedPlugins) {
            newPluginList.add(plugin.getShortName(), plugin.getVersion());
        }
        if (this.backupType == ThinBackupPeriodicWork.BackupType.FULL || newPluginList.compareTo(latestFullPlugins) != 0) {
            newPluginList.save();
        }
    }

    private IOFileFilter getDiffFilter() {
        IOFileFilter result = FileFilterUtils.trueFileFilter();
        if (this.backupType == ThinBackupPeriodicWork.BackupType.DIFF) {
            result = FileFilterUtils.ageFileFilter((Date)this.latestFullBackupDate, (boolean)false);
        }
        return result;
    }

    private Date getLatestFullBackupDate(File backupRoot) {
        IOFileFilter prefixFilter = FileFilterUtils.prefixFileFilter((String)ThinBackupPeriodicWork.BackupType.FULL.toString());
        List<File> backups = Arrays.asList(backupRoot.listFiles((FilenameFilter)prefixFilter));
        if (backups.isEmpty()) {
            return null;
        }
        Date latestBackupDate = null;
        for (File fullBackupDir : backups) {
            Date curModifiedDate = new Date(fullBackupDir.lastModified());
            if (latestBackupDate != null && !curModifiedDate.after(latestBackupDate)) continue;
            latestBackupDate = curModifiedDate;
        }
        return latestBackupDate;
    }
}

