/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.backup;

import hudson.XmlFile;
import hudson.model.Hudson;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginList
implements Comparable<PluginList> {
    private Map<String, String> plugins;
    private final transient File pluginsXml;

    public PluginList(File pluginsXml) {
        this.pluginsXml = pluginsXml;
        this.plugins = new HashMap<String, String>();
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    public void add(String name, String version) {
        this.plugins.put(name, version);
    }

    public void setPlugins(Map<String, String> plugins) {
        this.plugins = plugins;
    }

    public void save() throws IOException {
        new XmlFile(Hudson.XSTREAM, this.pluginsXml).write((Object)this);
    }

    public void load() throws IOException {
        XmlFile xmlFile = new XmlFile(Hudson.XSTREAM, this.pluginsXml);
        if (xmlFile.exists()) {
            xmlFile.unmarshal((Object)this);
        }
    }

    @Override
    public int compareTo(PluginList o) {
        if (o == null) {
            return -1;
        }
        Map<String, String> plugins2 = o.getPlugins();
        if (plugins2.size() != this.plugins.size()) {
            return -1;
        }
        for (Map.Entry<String, String> entry : this.plugins.entrySet()) {
            String plugin = entry.getKey();
            String version = entry.getValue();
            String prevVersion = plugins2.get(plugin);
            if (!StringUtils.isEmpty((String)version) && !StringUtils.isEmpty((String)prevVersion) && version.equals(prevVersion)) continue;
            return -1;
        }
        return 0;
    }
}

