/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.restore;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

public class HudsonRestore {
    private final String backupPath;
    private final String restoreBackupFrom;
    private final File hudsonHome;

    public HudsonRestore(File hudsonConfigurationPath, String backupPath, String restoreBackupFrom) {
        this.hudsonHome = hudsonConfigurationPath;
        this.backupPath = backupPath;
        this.restoreBackupFrom = restoreBackupFrom;
    }

    public void restore() throws IOException {
        File[] candidates;
        IOFileFilter suffixFilter = FileFilterUtils.suffixFileFilter((String)this.restoreBackupFrom);
        suffixFilter = FileFilterUtils.andFileFilter((IOFileFilter)suffixFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        if (!StringUtils.isEmpty((String)this.backupPath) && (candidates = new File(this.backupPath).listFiles((FileFilter)suffixFilter)).length == 1) {
            File toRestore = candidates[0];
            if (toRestore.getName().startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
                this.restore(Utils.getReferencedFullBackup(toRestore));
            }
            this.restore(toRestore);
        }
    }

    private void restore(File toRestore) throws IOException {
        FileUtils.copyDirectory((File)toRestore, (File)this.hudsonHome);
    }
}

