/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottleJobProperty
extends JobProperty<AbstractProject<?, ?>> {
    private Integer maxConcurrentPerNode;
    private Integer maxConcurrentTotal;

    @DataBoundConstructor
    public ThrottleJobProperty(Integer maxConcurrentPerNode, Integer maxConcurrentTotal) {
        this.maxConcurrentPerNode = maxConcurrentPerNode;
        this.maxConcurrentTotal = maxConcurrentTotal;
    }

    public boolean getThrottleEnabled() {
        return this.maxConcurrentPerNode != null && this.maxConcurrentPerNode != 0 || this.maxConcurrentTotal != null && this.maxConcurrentTotal != 0;
    }

    public Integer getMaxConcurrentPerNode() {
        if (this.maxConcurrentPerNode == null) {
            this.maxConcurrentPerNode = 0;
        }
        return this.maxConcurrentPerNode;
    }

    public Integer getMaxConcurrentTotal() {
        if (this.maxConcurrentTotal == null) {
            this.maxConcurrentTotal = 0;
        }
        return this.maxConcurrentTotal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(ThrottleJobProperty.class);
            this.load();
        }

        public String getDisplayName() {
            return "Throttle Concurrent Builds";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public FormValidation doCheckMaxConcurrentPerNode(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckMaxConcurrentTotal(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }
    }
}

