/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.plugins.throttleconcurrents.Messages;
import hudson.plugins.throttleconcurrents.ThrottleJobProperty;
import org.jvnet.localizer.Localizable;

@Extension
public class ThrottleQueueTaskDispatcher
extends QueueTaskDispatcher {
    public CauseOfBlockage canTake(Node node, Queue.Task task) {
        AbstractProject p;
        ThrottleJobProperty tjp;
        if (task instanceof AbstractProject && (tjp = (ThrottleJobProperty)(p = (AbstractProject)task).getProperty(ThrottleJobProperty.class)) != null && tjp.getThrottleEnabled()) {
            if (tjp.getMaxConcurrentPerNode() > 0) {
                int maxConcurrentPerNode = tjp.getMaxConcurrentPerNode();
                int runCount = 0;
                for (Executor e : node.toComputer().getExecutors()) {
                    if (e.getCurrentExecutable() == null || e.getCurrentExecutable().getParent() != task) continue;
                    ++runCount;
                }
                if (runCount >= maxConcurrentPerNode) {
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityOnNode(runCount));
                }
            } else if (tjp.getMaxConcurrentTotal() > 0) {
                int maxConcurrentTotal = tjp.getMaxConcurrentTotal();
                int totalRunCount = 0;
                for (Computer c : Hudson.getInstance().getComputers()) {
                    for (Executor e : c.getExecutors()) {
                        if (e.getCurrentExecutable() == null || e.getCurrentExecutable().getParent() != task) continue;
                        ++totalRunCount;
                    }
                }
                if (totalRunCount >= maxConcurrentTotal) {
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityTotal(totalRunCount));
                }
            }
        }
        return null;
    }
}

