/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottleJobProperty
extends JobProperty<AbstractProject<?, ?>> {
    @Deprecated
    transient String category;
    private Integer maxConcurrentPerNode;
    private Integer maxConcurrentTotal;
    private List<String> categories;
    private boolean throttleEnabled;
    private static Logger LOGGER = Logger.getLogger(ThrottleJobProperty.class.getName());

    @DataBoundConstructor
    public ThrottleJobProperty(Integer maxConcurrentPerNode, Integer maxConcurrentTotal, List<String> categories, boolean throttleEnabled) {
        this.maxConcurrentPerNode = maxConcurrentPerNode;
        this.maxConcurrentTotal = maxConcurrentTotal;
        this.categories = categories;
        this.throttleEnabled = throttleEnabled;
    }

    public Object readResolve() {
        if (this.category != null) {
            this.categories = new ArrayList<String>();
            this.categories.add(this.category);
        }
        return this;
    }

    public boolean getThrottleEnabled() {
        return this.throttleEnabled;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Integer getMaxConcurrentPerNode() {
        if (this.maxConcurrentPerNode == null) {
            this.maxConcurrentPerNode = 0;
        }
        return this.maxConcurrentPerNode;
    }

    public Integer getMaxConcurrentTotal() {
        if (this.maxConcurrentTotal == null) {
            this.maxConcurrentTotal = 0;
        }
        return this.maxConcurrentTotal;
    }

    public static final class ThrottleCategory {
        private Integer maxConcurrentPerNode;
        private Integer maxConcurrentTotal;
        private String categoryName;

        @DataBoundConstructor
        public ThrottleCategory(String categoryName, Integer maxConcurrentPerNode, Integer maxConcurrentTotal) {
            this.maxConcurrentPerNode = maxConcurrentPerNode;
            this.maxConcurrentTotal = maxConcurrentTotal;
            this.categoryName = categoryName;
        }

        public Integer getMaxConcurrentPerNode() {
            if (this.maxConcurrentPerNode == null) {
                this.maxConcurrentPerNode = 0;
            }
            return this.maxConcurrentPerNode;
        }

        public Integer getMaxConcurrentTotal() {
            if (this.maxConcurrentTotal == null) {
                this.maxConcurrentTotal = 0;
            }
            return this.maxConcurrentTotal;
        }

        public String getCategoryName() {
            return this.categoryName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private List<ThrottleCategory> categories;

        public DescriptorImpl() {
            super(ThrottleJobProperty.class);
            this.load();
        }

        public String getDisplayName() {
            return "Throttle Concurrent Builds";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public FormValidation doCheckMaxConcurrentPerNode(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckMaxConcurrentTotal(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public ThrottleCategory getCategoryByName(String categoryName) {
            ThrottleCategory category = null;
            for (ThrottleCategory tc : this.categories) {
                if (!tc.getCategoryName().equals(categoryName)) continue;
                category = tc;
            }
            return category;
        }

        public void setCategories(List<ThrottleCategory> categories) {
            this.categories = categories;
        }

        public List<ThrottleCategory> getCategories() {
            if (this.categories == null) {
                this.categories = new ArrayList<ThrottleCategory>();
            }
            return this.categories;
        }

        public ListBoxModel doFillCategoryItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("(none)", "");
            for (ThrottleCategory tc : this.getCategories()) {
                m.add(tc.getCategoryName());
            }
            return m;
        }
    }
}

