/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.plugins.throttleconcurrents.Messages;
import hudson.plugins.throttleconcurrents.ThrottleJobProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.localizer.Localizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ThrottleQueueTaskDispatcher
extends QueueTaskDispatcher {
    private static final Logger LOGGER = Logger.getLogger(ThrottleQueueTaskDispatcher.class.getName());

    public CauseOfBlockage canTake(Node node, Queue.Task task) {
        AbstractProject p;
        ThrottleJobProperty tjp;
        if (task instanceof AbstractProject && (tjp = (ThrottleJobProperty)(p = (AbstractProject)task).getProperty(ThrottleJobProperty.class)) != null && tjp.getThrottleEnabled()) {
            if (Hudson.getInstance().getQueue().isPending(task)) {
                return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_BuildPending());
            }
            if (tjp.getMaxConcurrentPerNode() > 0) {
                int maxConcurrentPerNode = tjp.getMaxConcurrentPerNode();
                int runCount = this.buildsOfProjectOnNode(node, task);
                if (runCount >= maxConcurrentPerNode) {
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityOnNode(runCount));
                }
            } else if (tjp.getMaxConcurrentTotal() > 0) {
                int maxConcurrentTotal = tjp.getMaxConcurrentTotal();
                int totalRunCount = this.buildsOfProjectOnAllNodes(task);
                if (totalRunCount >= maxConcurrentTotal) {
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityTotal(totalRunCount));
                }
            } else if (tjp.getCategories() != null && !tjp.getCategories().isEmpty()) {
                for (String catNm : tjp.getCategories()) {
                    if (catNm == null || catNm.equals("")) continue;
                    List<AbstractProject<?, ?>> categoryProjects = this.getCategoryProjects(catNm);
                    ThrottleJobProperty.ThrottleCategory category = ((ThrottleJobProperty.DescriptorImpl)tjp.getDescriptor()).getCategoryByName(catNm);
                    if (category == null) continue;
                    if (category.getMaxConcurrentPerNode() > 0) {
                        int maxConcurrentPerNode = category.getMaxConcurrentPerNode();
                        int runCount = 0;
                        for (AbstractProject<?, ?> catProj : categoryProjects) {
                            runCount += this.buildsOfProjectOnNode(node, (Queue.Task)catProj);
                        }
                        if (runCount < maxConcurrentPerNode) continue;
                        return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityOnNode(runCount));
                    }
                    if (category.getMaxConcurrentTotal() <= 0) continue;
                    int maxConcurrentTotal = category.getMaxConcurrentTotal();
                    int totalRunCount = 0;
                    for (AbstractProject<?, ?> catProj : categoryProjects) {
                        totalRunCount += this.buildsOfProjectOnAllNodes((Queue.Task)catProj);
                    }
                    if (totalRunCount < maxConcurrentTotal) continue;
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityTotal(totalRunCount));
                }
            }
        }
        return null;
    }

    private int buildsOfProjectOnNode(Node node, Queue.Task task) {
        int runCount = 0;
        LOGGER.fine("Checking for builds of " + task.getName() + " on node " + node.getDisplayName());
        for (Executor e : node.toComputer().getExecutors()) {
            if (e.getCurrentExecutable() == null || e.getCurrentExecutable().getParent() != task) continue;
            LOGGER.fine("Found one");
            ++runCount;
        }
        return runCount;
    }

    private int buildsOfProjectOnAllNodes(Queue.Task task) {
        int totalRunCount = 0;
        for (Computer c : Hudson.getInstance().getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (e.getCurrentExecutable() == null || e.getCurrentExecutable().getParent() != task) continue;
                ++totalRunCount;
            }
        }
        return totalRunCount;
    }

    private List<AbstractProject<?, ?>> getCategoryProjects(String category) {
        ArrayList categoryProjects = new ArrayList();
        if (category != null && !category.equals("")) {
            for (AbstractProject p : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                ThrottleJobProperty t = (ThrottleJobProperty)p.getProperty(ThrottleJobProperty.class);
                if (t == null || !t.getThrottleEnabled() || t.getCategories() == null || !t.getCategories().contains(category)) continue;
                categoryProjects.add(p);
            }
        }
        return categoryProjects;
    }
}

