/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.sql.Date;
import java.text.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimestampNote
extends ConsoleNote<Object> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };
    private final long millisSinceEpoch;

    TimestampNote(long millisSinceEpoch) {
        this.millisSinceEpoch = millisSinceEpoch;
    }

    public ConsoleAnnotator<Object> annotate(Object context, MarkupText text, int charPos) {
        String formattedDate = dateFormatThreadLocal.get().format(new Date(this.millisSinceEpoch));
        text.addMarkup(0, "<b>" + formattedDate + "</b>  ");
        return null;
    }
}

