/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.console.LineTransformationOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.timestamper.Messages;
import hudson.plugins.timestamper.TimestampNote;
import hudson.remoting.Channel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public final class TimestamperBuildWrapper
extends BuildWrapper {
    @DataBoundConstructor
    public TimestamperBuildWrapper() {
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){};
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return new TimestamperLauncher(launcher);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    private static class TimestamperOutputStream
    extends LineTransformationOutputStream {
        private final OutputStream delegate;

        private TimestamperOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        protected void eol(byte[] b, int len) throws IOException {
            new TimestampNote(System.currentTimeMillis()).encodeTo(this.delegate);
            this.delegate.write(b, 0, len);
        }

        public void close() throws IOException {
            super.close();
            this.delegate.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimestamperLauncher
    extends Launcher {
        private final Launcher delegate;

        private TimestamperLauncher(Launcher delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public Proc launch(Launcher.ProcStarter starter) throws IOException {
            Launcher.ProcStarter replacementProcStarter = starter.copy();
            TimestamperOutputStream replacementOutputStream = new TimestamperOutputStream(replacementProcStarter.stdout());
            replacementProcStarter.stdout((OutputStream)((Object)replacementOutputStream));
            return this.delegate.launch(replacementProcStarter);
        }

        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            return this.delegate.launchChannel(cmd, out, workDir, envVars);
        }

        public boolean isUnix() {
            return this.delegate.isUnix();
        }

        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.delegate.kill(modelEnvVars);
        }
    }
}

