/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import hudson.Extension;
import hudson.Launcher;
import hudson.console.LineTransformationOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.plugins.timestamper.Messages;
import hudson.plugins.timestamper.TimestampNote;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import org.kohsuke.stapler.DataBoundConstructor;

public final class TimestamperBuildWrapper
extends BuildWrapper {
    @DataBoundConstructor
    public TimestamperBuildWrapper() {
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){};
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) {
        return new TimestamperOutputStream(logger);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    private static class TimestamperOutputStream
    extends LineTransformationOutputStream {
        private final OutputStream delegate;

        private TimestamperOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        protected void eol(byte[] b, int len) throws IOException {
            new TimestampNote(System.currentTimeMillis()).encodeTo(this.delegate);
            this.delegate.write(b, 0, len);
        }

        public void close() throws IOException {
            super.close();
            this.delegate.close();
        }
    }
}

