/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tmpcleaner;

import hudson.os.PosixAPI;
import hudson.remoting.Callable;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.POSIX;
import org.kohsuke.stapler.framework.io.IOException2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmpCleanTask
implements Callable<Void, IOException> {
    private transient long criteria;
    private transient POSIX posix;
    private transient int euid;
    private String extraDirectories;
    private long days;
    private static final Logger LOGGER = Logger.getLogger(TmpCleanTask.class.getName());

    public TmpCleanTask(String extraDirectories, long days) {
        this.extraDirectories = extraDirectories;
        this.days = days;
    }

    public Void call() throws IOException {
        this.criteria = (System.currentTimeMillis() - TimeUnit2.DAYS.toMillis(this.days)) / 1000L;
        this.posix = PosixAPI.get();
        this.euid = this.posix.geteuid();
        File f = File.createTempFile("tmpclean", null);
        f.delete();
        this.visit(f.getParentFile());
        LOGGER.fine("extraDirectories " + this.extraDirectories + ", days " + this.days);
        try {
            if (this.extraDirectories != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.extraDirectories, ",");
                while (stringTokenizer.hasMoreElements()) {
                    File dir = new File(stringTokenizer.nextToken());
                    if (dir.exists()) {
                        this.visit(dir);
                        continue;
                    }
                    LOGGER.fine("dir " + dir.getPath() + " not exist ");
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException2(e.getMessage(), (Throwable)e);
        }
        finally {
            LOGGER.log(Level.INFO, " end TmpCleanTask ");
        }
        return null;
    }

    private void visit(File dir) {
        LOGGER.fine("visit " + dir);
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            long atime;
            FileStat stat;
            try {
                stat = this.posix.lstat(child.getPath());
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.INFO, "lstat failed on " + child + ", " + e.getMessage());
                continue;
            }
            if (stat.uid() != this.euid) {
                LOGGER.finer("Skipping " + child + " since we don't own it");
                continue;
            }
            if (stat.isDirectory()) {
                this.visit(child);
                String[] contents = child.list();
                if (contents != null && contents.length == 0) {
                    LOGGER.info("Deleting empty directory " + child);
                    child.delete();
                } else {
                    LOGGER.finer(child + " is not empty");
                }
            }
            if ((atime = stat.atime()) < this.criteria) {
                LOGGER.info(String.format("Deleting %s (atime=%d, diff=%d)", child, atime, atime - this.criteria));
                child.delete();
                continue;
            }
            LOGGER.finer("Skipping " + child + " since it's not old enough");
        }
    }

    public static void main(String[] args) throws IOException {
        LOGGER.setLevel(Level.FINE);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.FINE);
        LOGGER.addHandler(h);
        new TmpCleanTask("", 2L).call();
    }
}

