/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.toolenv;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolEnvBuildWrapper
extends BuildWrapper {
    public final String vars;

    @DataBoundConstructor
    public ToolEnvBuildWrapper(String vars) {
        this.vars = vars;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                for (String var : ToolEnvBuildWrapper.this.vars.split(",")) {
                    if (var.length() == 0) continue;
                    ToolInstallation tool = (ToolInstallation)ToolEnvBuildWrapper.toolsByVar().get(var);
                    if (tool == null) {
                        listener.error("No tool found matching " + var);
                        continue;
                    }
                    if (tool instanceof NodeSpecific) {
                        try {
                            tool = (ToolInstallation)((NodeSpecific)tool).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
                        }
                        catch (Exception x) {
                            x.printStackTrace(listener.error("Could not install " + var));
                            continue;
                        }
                    }
                    if (tool instanceof EnvironmentSpecific) {
                        EnvVars e = new EnvVars(env);
                        tool = (ToolInstallation)((EnvironmentSpecific)tool).forEnvironment(e);
                    }
                    String home = tool.getHome();
                    listener.getLogger().println("Setting " + var + "=" + home);
                    env.put(var, home);
                }
            }
        };
    }

    private static Map<String, ToolInstallation> toolsByVar() {
        TreeMap<String, ToolInstallation> r = new TreeMap<String, ToolInstallation>();
        for (ToolDescriptor desc : ToolInstallation.all()) {
            for (ToolInstallation inst : desc.getInstallations()) {
                r.put(inst.getName().replaceAll("[^a-zA-Z0-9_]+", "_").toUpperCase(Locale.ENGLISH) + "_HOME", inst);
            }
        }
        return r;
    }

    public static Collection<String> availableVariableNames() {
        return ToolEnvBuildWrapper.toolsByVar().keySet();
    }

    @Extension
    public static class Descriptor
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject item) {
            return true;
        }

        public String getDisplayName() {
            return "Tool Environment";
        }
    }
}

