/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trac;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.trac.TracProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracLinkAnnotator
extends ChangeLogAnnotator {
    private static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("(?:#|ticket:)NUM", "ticket/$1"), new LinkMarkup("comment:ticket:NUM:NUM", "ticket/$1#comment:$2"), new LinkMarkup("\\{NUM\\}|report:NUM", "report/$1$2"), new LinkMarkup("rNUM:NUM|\\[NUM:NUM\\]|log:@NUM:NUM", "log/?rev=$2$4$6&stop_ver=$1$3$5"), new LinkMarkup("rNUM(?!:)|\\[NUM\\]|changeset:NUM", "changeset/$1$2$3"), new LinkMarkup("((?:[A-Z][a-z]+)+)|wiki:ANYWORD", "wiki/$1$2"), new LinkMarkup("milestone:ANYWORD", "milestone/$1")};

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        TracProjectProperty tpp = (TracProjectProperty)build.getProject().getProperty(TracProjectProperty.class);
        if (tpp == null || tpp.tracWebsite == null) {
            return;
        }
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, tpp);
        }
    }

    private static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("(\\\\d+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("((?:\\\\w|[._-])+)");
            this.pattern = Pattern.compile(pattern);
            this.href = href;
        }

        void process(MarkupText text, TracProjectProperty prop) {
            String url = prop.tracWebsite;
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                st.surroundWith("<a href='" + url + this.href + "'>", "</a>");
            }
        }
    }
}

