/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trac;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.trac.TracProjectProperty;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.StaplerRequest;

public class TracRepositoryBrowser
extends SubversionRepositoryBrowser {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    private URL getTracWebURL(SubversionChangeLogSet.LogEntry cs) throws MalformedURLException {
        AbstractProject p = cs.getParent().build.getProject();
        TracProjectProperty tpp = (TracProjectProperty)p.getProperty(TracProjectProperty.class);
        if (tpp == null) {
            return null;
        }
        return new URL(tpp.tracWebsite);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        URL baseUrl = this.getTracWebURL(path.getLogEntry());
        int revision = path.getLogEntry().getRevision();
        return new URL(baseUrl, "changeset/" + revision + path.getValue() + "#file0");
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        URL baseUrl = this.getTracWebURL(path.getLogEntry());
        return baseUrl == null ? null : new URL(baseUrl, "browser" + path.getValue() + "#L1");
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        URL baseUrl = this.getTracWebURL(changeSet);
        return baseUrl == null ? null : new URL(baseUrl, "changeset/" + changeSet.getRevision());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(TracRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "Trac";
        }

        public TracRepositoryBrowser newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new TracRepositoryBrowser();
        }
    }
}

