/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.trac;

import hudson.model.AbstractProject;
import hudson.plugins.trac.TracProjectProperty;
import hudson.plugins.trac.TracRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class TracRepositoryBrowser
extends SubversionRepositoryBrowser {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public TracRepositoryBrowser() {
    }

    private URL getTracWebURL(SubversionChangeLogSet.LogEntry cs) throws MalformedURLException {
        AbstractProject p = cs.getParent().build.getProject();
        TracProjectProperty tpp = (TracProjectProperty)p.getProperty(TracProjectProperty.class);
        if (tpp == null) {
            return null;
        }
        return new URL(tpp.tracWebsite);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        URL baseUrl = this.getTracWebURL(path.getLogEntry());
        int revision = path.getLogEntry().getRevision();
        return new URL(baseUrl, "changeset/" + revision + path.getValue() + "#file0");
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        URL baseUrl = this.getTracWebURL(path.getLogEntry());
        return baseUrl == null ? null : new URL(baseUrl, "browser" + path.getValue() + "#L1");
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        URL baseUrl = this.getTracWebURL(changeSet);
        return baseUrl == null ? null : new URL(baseUrl, "changeset/" + changeSet.getRevision());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }
}

